% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{read_drake_graph}
\alias{read_drake_graph}
\title{Read the igraph dependency network
from your last attempted call to \code{\link{make}()}.}
\usage{
read_drake_graph(path = getwd(), search = TRUE, cache = NULL,
  verbose = 1, ...)
}
\arguments{
\item{path}{Root directory of the drake project,
or if \code{search} is \code{TRUE}, either the
project root or a subdirectory of the project.}

\item{search}{logical. If \code{TRUE}, search parent directories
to find the nearest drake cache. Otherwise, look in the
current working directory only.}

\item{cache}{optional drake cache. See code{\link{new_cache}()}.
If \code{cache} is supplied,
the \code{path} and \code{search} arguments are ignored.}

\item{verbose}{logical, whether to print console messages}

\item{...}{arguments to \code{visNetwork()} via
\code{\link{vis_drake_graph}()}}
}
\value{
An \code{igraph} object representing the dependency
network of the workflow.
}
\description{
For more user-friendly graphing utilities,
see \code{\link{vis_drake_graph}()}
and related functions.
}
\examples{
\dontrun{
test_with_dir("Quarantine side effects.", {
load_basic_example() # Get the code with drake_example("basic").
make(my_plan) # Run the project, build the targets.
# Retrieve the igraph network from the cache.
g <- read_drake_graph()
class(g) # "igraph"
})
}
}
\seealso{
\code{\link{vis_drake_graph}}, \code{\link{read_drake_config}}
}
