% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/code_to_plan.R
\name{code_to_plan}
\alias{code_to_plan}
\title{Turn an R script file or knitr / R Markdown report
into a \code{drake} workflow plan data frame.}
\usage{
code_to_plan(path)
}
\arguments{
\item{path}{a file path to an R script or \code{knitr} report.}
}
\description{
In your script or \code{knitr} / R Markdown code chunks,
you can assign expressions to variables,
and \code{code_to_plan()} will turn them into commands and targets,
respectively.
}
\details{
This feature is easy to break, so there are some rules
for your code file:
\enumerate{
\item Stick to assigning a single expression to a single target at a time.
For multi-line commands, please enclose the whole command
in curly braces.
Conversely, compound assignment is not supported
(e.g. \code{target_1 <- target_2 <- target_3 <- get_data()}).
\item Once you assign an expression to a variable,
do not modify the variable any more.
The target/command binding should be permanent.
\item Keep it simple. Please use the assignment operators rather than
\code{assign()} and similar functions.
}
}
\examples{
\dontrun{
test_with_dir("Quarantine side effects.", {
drake_example("code_to_plan") # Download some code files to make plans.
# Read the code and Markdown files in the downloaded "code_to_plan"
# folder for details.
plan <- code_to_plan("code_to_plan/script.R")
plan2 <- code_to_plan("code_to_plan/report.Rmd")
identical(plan, plan2) # should be TRUE
print(plan)
make(plan)
readd(discrepancy)
})
}
}
\seealso{
\code{\link[=drake_plan]{drake_plan()}}, \code{\link[=make]{make()}}
}
