% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parallel_ui.R
\name{parallelism_choices}
\alias{parallelism_choices}
\title{List the types of supported parallel computing in drake.}
\usage{
parallelism_choices(distributed_only = FALSE)
}
\arguments{
\item{distributed_only}{logical, whether to return only
the distributed backend types, such as \code{Makefile} and
\code{parLapply}}
}
\value{
Character vector listing the types of parallel
computing supported.
}
\description{
These are the possible values of the
\code{parallelism} argument to \code{\link[=make]{make()}}.
}
\details{
See the
\href{https://ropenscilabs.github.io/drake-manual/hpc.html}{high-performance computing guide} # nolint
for details on the parallel backends.
}
\examples{
# See all the parallel computing options.
parallelism_choices()
# See just the distributed computing options.
parallelism_choices(distributed_only = TRUE)
}
\seealso{
\code{\link[=make]{make()}}, \code{\link[=shell_file]{shell_file()}}
}
