% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api-cache.R
\name{cached}
\alias{cached}
\title{List targets in the cache.}
\usage{
cached(..., list = character(0), no_imported_objects = FALSE,
  path = getwd(), search = TRUE, cache = NULL, verbose = 1L,
  namespace = NULL, jobs = 1, targets_only = TRUE)
}
\arguments{
\item{...}{Deprecated. Do not use.
Objects to load from the cache, as names (unquoted)
or character strings (quoted). Similar to \code{...} in
\code{remove()}.}

\item{list}{Deprecated. Do not use.
Character vector naming objects to be loaded from the
cache. Similar to the \code{list} argument of \code{\link[=remove]{remove()}}.}

\item{no_imported_objects}{Logical, deprecated. Use
\code{targets_only} instead.}

\item{path}{Root directory of the drake project,
or if \code{search} is \code{TRUE}, either the
project root or a subdirectory of the project.
Ignored if a \code{cache} is supplied.}

\item{search}{Logical. If \code{TRUE}, search parent directories
to find the nearest drake cache. Otherwise, look in the
current working directory only.
Ignored if a \code{cache} is supplied.}

\item{cache}{drake cache. See \code{\link[=new_cache]{new_cache()}}.
If supplied, \code{path} and \code{search} are ignored.}

\item{verbose}{Logical or numeric, control printing to the console.
\itemize{
\item \code{0} or \code{FALSE}: print nothing.
\item \code{1} or \code{TRUE}: print only targets to build.
\item \code{2}: plus checks and cache info.
\item \code{3}: plus missing imports.
\item \code{4}: plus all imports.
\item \code{5}: plus execution and total build times for targets.
\item \code{6}: plus notifications when targets are being stored.
}}

\item{namespace}{Character scalar, name of the storr namespace
to use for listing objects.}

\item{jobs}{Number of jobs/workers for parallel processing.}

\item{targets_only}{Logical. If \code{TRUE} just list the targets.
If \code{FALSE}, list files and imported objects too.}
}
\value{
Either a named logical indicating whether the given
targets or cached or a character vector listing all cached
items, depending on whether any targets are specified.
}
\description{
Tip: read/load a cached item with \code{\link[=readd]{readd()}}
or \code{\link[=loadd]{loadd()}}.
}
\examples{
\dontrun{
test_with_dir("Quarantine side effects.", {
if (suppressWarnings(require("knitr"))) {
if (requireNamespace("lubridate")) {
load_mtcars_example() # Load drake's canonical example.
make(my_plan) # Run the project, build all the targets.
cached()
cached(targets_only = FALSE)
}
}
})
}
}
\seealso{
\code{\link[=readd]{readd()}}, \code{\link[=loadd]{loadd()}},
\code{\link[=drake_plan]{drake_plan()}}, \code{\link[=make]{make()}}
}
