% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api-clean.R
\name{clean}
\alias{clean}
\title{Remove targets/imports from the cache.}
\usage{
clean(..., list = character(0), destroy = FALSE, path = getwd(),
  search = TRUE, cache = NULL, verbose = 1L, jobs = 1,
  force = FALSE, garbage_collection = FALSE, purge = FALSE)
}
\arguments{
\item{...}{Targets to remove from the cache: as names (symbols) or
character strings. If the \code{tidyselect} package is installed,
you can also supply \code{dplyr}-style \code{tidyselect}
commands such as \code{starts_with()}, \code{ends_with()}, and \code{one_of()}.}

\item{list}{Character vector naming targets to be removed from the
cache. Similar to the \code{list} argument of \code{\link[=remove]{remove()}}.}

\item{destroy}{Logical, whether to totally remove the drake cache.
If \code{destroy} is \code{FALSE}, only the targets
from \code{make()}
are removed. If \code{TRUE}, the whole cache is removed, including
session metadata, etc.}

\item{path}{Root directory of the drake project,
or if \code{search} is \code{TRUE}, either the
project root or a subdirectory of the project.
Ignored if a \code{cache} is supplied.}

\item{search}{Logical. If \code{TRUE}, search parent directories
to find the nearest drake cache. Otherwise, look in the
current working directory only.
Ignored if a \code{cache} is supplied.}

\item{cache}{drake cache. See \code{\link[=new_cache]{new_cache()}}.
If supplied, \code{path} and \code{search} are ignored.}

\item{verbose}{Integer, control printing to the console/terminal.
\itemize{
\item \code{0}: print nothing.
\item \code{1}: print targets, retries, and failures.
\item \code{2}: also show a spinner when preprocessing tasks are underway.
}}

\item{jobs}{Number of jobs for light parallelism
(disabled on Windows).}

\item{force}{Logical, whether to try to clean the cache
even though the project may not be back compatible with the
current version of drake.}

\item{garbage_collection}{Logical, whether to call
\code{cache$gc()} to do garbage collection.
If \code{TRUE}, cached data with no remaining references
will be removed.
This will slow down \code{clean()}, but the cache
could take up far less space afterwards.
See the \code{gc()} method for \code{storr} caches.}

\item{purge}{Logical, whether to remove objects from
metadata namespaces such as "meta", "build_times", and "errors".}
}
\value{
Invisibly return \code{NULL}.
}
\description{
Cleans up the work done by \code{\link[=make]{make()}}.
}
\details{
By default, \code{clean()} removes references to cached data.
To deep-clean the data to free up storage/memory, use
\code{clean(garbage_collection = TRUE)}. Garbage collection is slower,
but it purges data with no remaining references. To just do garbage
collection without cleaning, see \code{\link[=drake_gc]{drake_gc()}}.
Also, for \code{clean()}, you must be in your project's working directory
or a subdirectory of it.
\code{clean(search = TRUE)} searches upwards in your folder structure
for the drake cache and acts on the first one it sees. Use
\code{search = FALSE} to look within the current working
directory only.
WARNING: This deletes ALL work done with \code{\link[=make]{make()}},
which includes
file targets as well as the entire drake cache. Only use \code{clean()}
if you're sure you won't lose anything important.
}
\section{Safeguards}{

If you run \code{\link[=clean]{clean()}} with no arguments, \code{drake}'s response is to
remove all the targets etc. from the cache. To prevent you from
doing this accidentally in an interactive session, \code{\link[=clean]{clean()}}
prompts you with a menu to confirm. The menu only appears
once per session. You can disable it with
\code{options(drake_clean_menu = FALSE)}.
}

\examples{
\dontrun{
test_with_dir("Quarantine side effects.", {
if (suppressWarnings(require("knitr"))) {
load_mtcars_example() # Get the code with drake_example("mtcars").
make(my_plan) # Run the project, build the targets.
# List objects in the cache, excluding R objects
# imported from your workspace.
cached(no_imported_objects = TRUE)
# Remove 'summ_regression1_large' and 'small' from the cache.
clean(summ_regression1_large, small)
# Those objects should be gone.
cached(no_imported_objects = TRUE)
# Rebuild the missing targets.
make(my_plan)
# Remove all the targets and imports.
# On non-Windows machines, parallelize over at most 2 jobs.
clean(jobs = 2)
# Make the targets again.
make(my_plan)
# Garbage collection removes data whose references are no longer present.
# It is slow, but you should enable it if you want to reduce the
# size of the cache.
clean(garbage_collection = TRUE)
# All the targets and imports are gone.
cached()
# But there is still cached metadata.
build_times()
# To make even more room, use the "purge" flag.
clean(purge = TRUE)
build_times()
# Completely remove the entire cache (default: '.drake/' folder).
clean(destroy = TRUE)
}
})
}
}
\seealso{
\code{\link[=drake_gc]{drake_gc()}}, \code{\link[=make]{make()}}
}
