% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api-progress.R
\name{failed}
\alias{failed}
\title{List failed targets.
to \code{\link[=make]{make()}}.}
\usage{
failed(path = NULL, search = NULL, cache = drake::drake_cache(path =
  path, verbose = verbose), verbose = 1L, upstream_only = NULL)
}
\arguments{
\item{path}{Path to a \code{drake} cache
(usually a hidden \code{.drake/} folder) or \code{NULL}.}

\item{search}{Deprecated.}

\item{cache}{drake cache. See \code{\link[=new_cache]{new_cache()}}.
If supplied, \code{path} is ignored.}

\item{verbose}{Integer, control printing to the console/terminal.
\itemize{
\item \code{0}: print nothing.
\item \code{1}: print targets, retries, and failures.
\item \code{2}: also show a spinner when preprocessing tasks are underway.
}}

\item{upstream_only}{Deprecated.}
}
\value{
A character vector of target names.
}
\description{
Together, functions \code{failed()} and
\code{\link[=diagnose]{diagnose()}} should eliminate the strict need
for ordinary error messages printed to the console.
}
\examples{
\dontrun{
isolate_example("Quarantine side effects.", {
if (suppressWarnings(require("knitr"))) {
load_mtcars_example() # Get the code with drake_example("mtcars").
make(my_plan) # Run the project, build the targets.
failed() # Should show that no targets failed.
# Build a workflow plan doomed to fail:
bad_plan <- drake_plan(x = function_doesnt_exist())
try(make(bad_plan), silent = TRUE) # error
failed() # "x"
diagnose(x) # Retrieve the cached error log of x.
}
})
}
}
\seealso{
\code{\link[=running]{running()}}, \code{\link[=make]{make()}}
}
