% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis-visnetwork.R
\name{render_drake_graph}
\alias{render_drake_graph}
\title{Render a visualization using the data frames
generated by \code{\link[=drake_graph_info]{drake_graph_info()}}.}
\usage{
render_drake_graph(graph_info, file = character(0), layout = NULL,
  direction = NULL, hover = TRUE, main = graph_info$default_title,
  selfcontained = FALSE, navigationButtons = TRUE, ncol_legend = 1,
  collapse = TRUE, ...)
}
\arguments{
\item{graph_info}{List of data frames generated by
\code{\link[=drake_graph_info]{drake_graph_info()}}.
There should be 3 data frames: \code{nodes}, \code{edges},
and \code{legend_nodes}.}

\item{file}{Name of a file to save the graph.
If \code{NULL} or \code{character(0)}, no file is saved and
the graph is rendered and displayed within R.
If the file ends in a \code{.png}, \code{.jpg}, \code{.jpeg}, or \code{.pdf} extension,
then a static image will be saved. In this case,
the webshot package and PhantomJS are required:
\code{install.packages("webshot"); webshot::install_phantomjs()}.
If the file does not end in a \code{.png}, \code{.jpg}, \code{.jpeg}, or \code{.pdf}
extension, an HTML file will be saved, and you can open the
interactive graph using a web browser.}

\item{layout}{Deprecated.}

\item{direction}{Deprecated.}

\item{hover}{Logical, whether to show the command that generated the target
when you hover over a node with the mouse. For imports, the label does not
change with hovering.}

\item{main}{Character string, title of the graph.}

\item{selfcontained}{Logical, whether
to save the \code{file} as a self-contained
HTML file (with external resources base64 encoded) or a file with
external resources placed in an adjacent directory. If \code{TRUE},
pandoc is required. The \code{selfcontained} argument only applies
to HTML files. In other words, if \code{file} is a
PNG, PDF, or JPEG file, for instance,
the point is moot.}

\item{navigationButtons}{Logical, whether to add navigation buttons with
\code{visNetwork::visInteraction(navigationButtons = TRUE)}}

\item{ncol_legend}{Number of columns in the legend nodes.
To remove the legend entirely, set \code{ncol_legend} to \code{NULL} or \code{0}.}

\item{collapse}{Logical, whether to allow nodes to collapse
if you double click on them.
Analogous to \code{visNetwork::visOptions(collapse = TRUE)} or
\code{visNetwork::visOptions(collapse = TRUE)}.}

\item{...}{Arguments passed to \code{visNetwork()}.}
}
\value{
A \code{visNetwork} graph.
}
\description{
This function is called inside
\code{\link[=vis_drake_graph]{vis_drake_graph()}}, which typical users
call more often.
}
\examples{
\dontrun{
isolate_example("Quarantine side effects.", {
if (suppressWarnings(require("knitr"))) {
load_mtcars_example() # Get the code with drake_example("mtcars").
if (requireNamespace("visNetwork", quietly = TRUE)) {
# Instead of jumpting right to vis_drake_graph(), get the data frames
# of nodes, edges, and legend nodes.
config <- drake_config(my_plan) # Internal configuration list
vis_drake_graph(config) # Jump straight to the interactive graph.
# Get the node and edge info that vis_drake_graph() just plotted:
graph <- drake_graph_info(config)
# You can pass the data frames right to render_drake_graph()
# (as in vis_drake_graph()) or you can create
# your own custom visNewtork graph.
render_drake_graph(graph, width = '100\%') # Width is passed to visNetwork.
}
}
})
}
}
\seealso{
\code{\link[=vis_drake_graph]{vis_drake_graph()}}, \code{\link[=sankey_drake_graph]{sankey_drake_graph()}},
\code{\link[=drake_ggraph]{drake_ggraph()}}
}
