% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache.R
\name{drake_cache}
\alias{drake_cache}
\title{Get the cache of a \code{drake} project.
\lifecycle{stable}}
\usage{
drake_cache(path = NULL, verbose = 1L, console_log_file = NULL)
}
\arguments{
\item{path}{Character.
Set \code{path} to the path of a \code{storr::storr_rds()} cache
to retrieve a specific cache generated by \code{storr::storr_rds()}
or \code{drake::new_cache()}. If the \code{path} argument is \code{NULL},
\code{drake_cache()} searches up through parent directories
to find a folder called \code{.drake/}.}

\item{verbose}{Integer, control printing to the console/terminal.
\itemize{
\item \code{0}: print nothing.
\item \code{1}: print targets, retries, and failures.
\item \code{2}: also show a spinner when preprocessing tasks are underway.
}}

\item{console_log_file}{Optional character scalar of a file name or
connection object (such as \code{stdout()}) to dump maximally verbose
log information for \code{\link[=make]{make()}} and other functions (all functions that
accept a \code{config} argument, plus \code{drake_config()}).
If you choose to use a text file as the console log,
it will persist over multiple function calls
until you delete it manually.
Fields in each row the log file, from left to right:
- The node name (short host name) of the
computer (from \code{Sys.info()["nodename"]}).
- The process ID (from \code{Sys.getpid()}).
- A timestamp with the date and time (in microseconds).
- A brief description of what \code{drake} was doing.\code{ The fields are separated by pipe symbols (}"|"`).}
}
\value{
A drake/storr cache in a folder called \code{.drake/},
if available. \code{NULL} otherwise.
}
\description{
\code{\link[=make]{make()}} saves the values of your targets so
you rarely need to think about output files. By default,
the cache is a hidden folder called \code{.drake/}.
You can also supply your own \code{storr} cache to the \code{cache}
argument of \code{make()}. The \code{drake_cache()} function retrieves
this cache.
}
\details{
\code{drake_cache()} actually returns a \emph{decorated} \code{storr},
an object that \emph{contains} a \code{storr} (plus bells and whistles).
To get the \emph{actual} inner \code{storr}, use \code{drake_cache()$storr}.
}
\examples{
\dontrun{
isolate_example("Quarantine side effects.", {
if (suppressWarnings(require("knitr"))) {
clean(destroy = TRUE)
# No cache is available.
drake_cache() # NULL
load_mtcars_example() # Get the code with drake_example("mtcars").
make(my_plan) # Run the project, build the targets.
x <- drake_cache() # Now, there is a cache.
y <- storr::storr_rds(".drake") # Nearly equivalent.
# List the objects readable from the cache with readd().
x$list()
# drake_cache() actually returns a *decorated* storr.
# The *real* storr is inside.
drake_cache()$storr
}
})
}
}
\seealso{
\code{\link[=new_cache]{new_cache()}}, \code{\link[=drake_config]{drake_config()}}
}
