% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expose_imports.R
\name{expose_imports}
\alias{expose_imports}
\title{Expose package functions and objects for analysis with drake
\lifecycle{stable}}
\usage{
expose_imports(
  package,
  character_only = FALSE,
  envir = parent.frame(),
  jobs = 1
)
}
\arguments{
\item{package}{Name of the package, either a symbol or a string,
depending on \code{character_only}.}

\item{character_only}{Logical, whether to interpret \code{package}
as a character string or a symbol (quoted vs unquoted).}

\item{envir}{Environment to load the exposed package imports.
You will later pass this \code{envir} to \code{\link[=make]{make()}}.}

\item{jobs}{Number of parallel jobs for the parallel processing
of the imports.}
}
\value{
The environment that the exposed imports are loaded into.
Defaults to your R workspace.
}
\description{
\code{drake} usually ignores the functions and objects
from packages. Use \code{expose_imports()} to bring the functions and
objects from a package into your environment. That way,
\code{drake} scans them for dependencies and watches for when
they change.
}
\details{
Thanks to \href{https://github.com/dapperjapper}{Jasper Clarkberg}
for the idea that makes this function work.
}
\examples{
# nolint start
\dontrun{
isolate_example("contain side effects", {
# Consider a simple plan that depends on the biglm package.
# library(biglm)
plan <- drake_plan(model = biglm(y ~ x, data = huge_dataset))
# Even if you load the biglm package, drake still ignores
# the biglm() function as a dependency. The function is missing
# from the graph:
# config <- drake_config(plan)
# vis_drake_graph(config)
# And if you install an updated version of biglm with a revised
# biglm() function, this will not cause drake::make(plan)
# to rerun the model.
# This is because biglm() is not in your environment.
# ls()
# biglm() exists in its own special package environment,
# which drake does not scan.
# ls("package:biglm")
# To depend on biglm(), use expose_imports(biglm)
# to bring the objects and functions in biglm into
# your own (non-package) environment.
# expose_imports(biglm)
# Now, the biglm() function should be in your environment.
# ls()
# biglm() now appears in the graph.
# vis_drake_graph(config)
# And subsequent make()s respond to changes to biglm()
# and its dependencies.
})
}
# nolint end
}
