% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_sample.R
\name{draw_sample}
\alias{draw_sample}
\title{Draw Samples with the Desired Properties from a Data Set}
\usage{
draw_sample(
  dist,
  n,
  skew,
  kurts,
  replacement = FALSE,
  output_name = c("sample", "default")
)
}
\arguments{
\item{dist}{data frame:consists of id and scores with no missing}

\item{n}{numeric: desired sample size}

\item{skew}{numeric: the skewness value}

\item{kurts}{numeric: the kurtosis value}

\item{replacement}{logical:Sample with or without replacement?
(default is FALSE).}

\item{output_name}{character: a vector of two components.
The first component is the name of the output file,
user can change the second component.}
}
\value{
This function returns a \code{list} including following:
\itemize{
\item a matrix: Descriptive statistics of the given data,
                the reference vector and the sample.
\item a data frame: The id's and scores of the sample
\item graph: Histograms for the “data” and the “sample”
}
}
\description{
A function to sample data with desired properties.
}
\details{
The execution of the function may take some time since it tries to obtain
the specified value for skewness and kurtosis.
}
\examples{
# Example data provided with package
data(example_data)
\dontrun{
# Draw a sample based on Score_1(from negatively skewed to normal)
# draw_sample(dist=example_data[,c(1,2)],n=200,skew = 0,kurts = 0,
# output_name = c("sample", "1"))
# Draw a sample based on Score_2 (from negatively skewed to positively skewed)
# draw_sample(dist=example_data[,c(1,3)],n=200,skew = 1,kurts = 1,
# output_name = c("sample", "2"))
# Draw a sample based on Score_2 (from negatively skewed to positively skewed
# with replacement)
# draw_sample(dist=example_data[,c(1,3)],n=200,skew = 0.5,kurts = 0.4,
# replacement=TRUE,output_name = c("sample", "3"))
}
}
\references{
Fleishman AI (1978). A Method for Simulating Non-normal Distributions.
 \emph{Psychometrika, 43, 521-532.} \doi{10.1007/BF02293811}.

Fialkowski, A. C.  (2018). SimMultiCorrData: Simulation of Correlated Data
with Multiple #' Variable Types.  R package version 0.2.2. Retrieved from
https://cran.r-project.org/web/packages/SimMultiCorrData/index.html

Atalay Kabasakal, K. & Gunduz, T. (2020). Drawing a Sample with Desired Properties from 
Population in R Package “drawsample”.\emph{Journal of Measurement and Evaluation in Education 
and Psychology,11}(4),405-429. \doi{10.21031/epod.790449}
}
