"drmOpt" <- 
function(opfct, opdfct1, startVec, optMethod, constrained, warnVal, 
upperLimits, lowerLimits, errorMessage, maxIt, relTol, opdfct2 = NULL, parmVec, trace) 
{
    ## Controlling the warnings
    options(warn = warnVal)   
    
    ## Calculating hessian
    if (is.null(opdfct2)) {hes <- TRUE} else {hes <- FALSE}

    ## Optimising
    psVec <- abs(startVec)
    psVec[psVec < 1e-4] <- 1

    ## Derivatives are used
    {if (!is.null(opdfct1))
    {
        if (constrained)
        {
            nlsObj <- try(optim(startVec, opfct, opdfct1, hessian = hes, method = "L-BFGS-B", 
            lower = lowerLimits, upper = upperLimits, control = list(maxit = maxIt)), silent = TRUE)
        } else {
            nlsObj <- try(optim(startVec, opfct, opdfct1, hessian = hes, method = optMethod, 
            control = list(maxit = maxIt, reltol = relTol, parscale = psVec)), silent = TRUE)
        }
        options(warn = 0)
        
        if (!inherits(nlsObj, "try-error")) 
        {
            nlsFit <- nlsObj
            nlsFit$convergence <- TRUE
        } else {
#            stop("Convergence failed")
            warning("Convergence failed. The model was not fitted!", call. = FALSE)

            callDetail <- match.call()
            if (is.null(callDetail$fct)) {callDetail$fct <- substitute(l4())}
            return(list(call = callDetail, parNames = parmVec, startVal = startVec, convergence = FALSE))
        }
        if (!hes) {nlsFit$hessian <- opdfct2(parmVal)}

    ## Derivatives are not used
    } else {  

        if (constrained)
        {
            nlsObj <- try(optim(startVec, opfct, hessian = TRUE, method = "L-BFGS-B", 
            lower = lowerLimits, upper = upperLimits, 
            control = list(maxit = maxIt)), silent = TRUE)
            ## no to add: ", reltol = relTol, parscale = psVec, trace = trace"
        } else {
#            psVec <- abs(startVec)
#            psVec[psVec<1e-4] <- 1

            nlsObj <- try(optim(startVec, opfct, hessian = TRUE, method = optMethod, 
            control = list(maxit = maxIt, reltol = relTol, parscale = psVec, trace = trace)) , silent = TRUE)
#            nlsObj0 <- try(optim(startVec, opfct, method=optMethod, 
#            control=list(maxit=maxIt, reltol=relTol, parscale=psVec)), silent=TRUE)
#            nlsObj <- try(optim(nlsObj0$par, opfct, hessian=TRUE, method=optMethod, 
#            control=list(maxit=maxIt, reltol=relTol)), silent=TRUE)
        }
        options(warn = 0)
        
        if (!inherits(nlsObj, "try-error")) 
        {
            nlsFit <- nlsObj
            nlsFit$convergence <- TRUE            
        } else {  # to avoid an error if used in a loop
            if (errorMessage) 
            {
                stop("Convergence failed")
            } else {
                warning("Convergence failed. The model was not fitted!", call. = FALSE)
            }

            callDetail <- match.call()
            if (is.null(callDetail$fct)) {callDetail$fct <- substitute(l4())}
            return(list(call = callDetail, parNames = parmVec, startVal = startVec, convergence = FALSE))
        }
    }}
    
#    nlsFit$ofvalue <- nlsFit$value
    nlsFit$ovalue <- nlsFit$value  # used in the var-cov matrix ... check
#    nlsFit$value <- opfct(nlsFit$par, scaling = FALSE)  # used in the residual variance ... check    
    nlsFit$value <- opfct(nlsFit$par)

    ## returning the fit
    return(nlsFit)
}
