% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_funs.R
\name{sfill}
\alias{sfill}
\title{Fills a string vector with a symbol}
\usage{
sfill(x = "", n = NULL, symbol = " ", right = FALSE, anchor)
}
\arguments{
\item{x}{A character vector.}

\item{n}{A positive integer giving the total expected length of each character string. Can be NULL (default). If \code{NULL}, then \code{n} is set to the maximum number of characters in \code{x} (i.e. \code{max(nchar(x))}).}

\item{symbol}{Character scalar, default to \code{" "}. The symbol used to fill.}

\item{right}{Logical, default is \code{FALSE}. Whether the character vector should be filled on the left( default) or on the right.}

\item{anchor}{Character scalar, can be missing. If provided, the filling is done up to this anchor. See examples.}
}
\value{
Returns a character vector of the same length as \code{x}.
}
\description{
Fills a string vector with a user-provided symbol, up to the required length.
}
\examples{

# Some self-explaining examples
x = c("hello", "I", "am", "No-one")
cat(sep = "\n", sfill(x))
cat(sep = "\n", sfill(x, symbol = "."))
cat(sep = "\n", sfill(x, symbol = ".", n = 15))
cat(sep = "\n", sfill(x, symbol = ".", right = TRUE))

cat(sep = "\n", paste(sfill(x, symbol = ".", right = TRUE), ":", 1:4))

# Argument 'anchor' can be useful when using numeric vectors
x = c(-15.5, 1253, 32.52, 665.542)
cat(sep = "\n", sfill(x))
cat(sep = "\n", sfill(x, anchor = "."))

}
