% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dmm.R
\name{simulate.dmm}
\alias{simulate.dmm}
\title{Simulate a sequence under a drifting Markov model}
\usage{
\method{simulate}{dmm}(x, output_file = NULL, model_size = NULL, ncpu = 2)
}
\arguments{
\item{x}{An object of class \code{dmm}}

\item{output_file}{(Optional) File containing the simulated sequence (e.g, "C:/.../SIM.txt")}

\item{model_size}{Size of the model}

\item{ncpu}{Default=2. Represents the number of cores used to parallelized computation. If ncpu=-1, then it uses all available cores.}
}
\value{
the vector of simulated sequence
}
\description{
Simulate a sequence under a k-th order DMM.
}
\examples{
data(lambda, package = "drimmR")
dmm <- fitdmm(lambda, 1, 1, c('a','c','g','t'), init.estim = "freq", fit.method="sum")
simulate(dmm, model_size=100)
}
\references{
\insertRef{BaVe2018}{drimmR}
\insertRef{Ver08}{drimmR}
}
\seealso{
\link[drimmR]{fitdmm}, \link[drimmR]{getTransitionMatrix}, \link[drimmR]{getStationaryLaw}
}
\author{
Annthomy Gilles, Alexandre Seiller
}
