% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotci.R
\name{plotci}
\alias{plotci}
\title{Plot estimated confidence interval of total population size from object of class \code{popsize} or \code{popsize_cond}.}
\usage{
plotci(object, tsize = 12, ...)
}
\arguments{
\item{object}{An object of class \code{popsize} or \code{popsize_cond}.}

\item{tsize}{The text size for the plots.}

\item{...}{Any extra arguments passed into the function.}
}
\value{
A ggplot object \code{fig} with population size estimates and the 95\% confidence intervals.
}
\description{
Plot estimated confidence interval of total population size from object of class \code{popsize} or \code{popsize_cond}.
}
\examples{
\donttest{
data = simuldata(n = 10000, l = 1)$data_xstar

p = popsize(data = data, funcname = c("logit", "gam"))
plotci(p)

data = simuldata(n = 10000, l = 1, categorical = TRUE)$data_xstar
p = popsize_cond(data = data, condvar = 'catcov')
plotci(p)
}
}
\references{
H. Wickham. ggplot2: Elegant Graphics for Data Analysis. \emph{Springer-Verlag} New York, 2016.
}
