% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.HarbronFit.R
\name{fitPlot2d}
\alias{fitPlot2d}
\title{Plot 2d surface (slices) of observations and model fit}
\usage{
fitPlot2d(fit, fit2 = NULL, side = c("d1", "d2", "total"),
  useFineGrid = TRUE, modelNames = NULL)
}
\arguments{
\item{fit}{A \code{HarbronFit} object returned by \code{\link{fitModel}}.}

\item{fit2}{An optional \code{HarbronFit} object returned by 
\code{\link{fitModel}}. If provided, a 2d-plot comparing two model fits is 
produced. Note that the two models should have been fitted on the same data. 
Note that this argument can also be used as \code{side}.}

\item{side}{Which side ("d1", "d2" or "total" for the sum of d1 and d2) to 
use as x-axis.}

\item{useFineGrid}{Whether to use fine grid for plotting fitted curves 
(default), or calculate predictions only at the observed data points.}

\item{modelNames}{Model names to use for the plot legend in the case of model 
comparison (i.e. when \code{fit2} is provided).}
}
\value{
ggplot2 object
}
\description{
Plot 2d surface (slices) of observations and model fit
}
\author{
Maxim Nazarov
}
