% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{posPsy_long}
\alias{posPsy_long}
\title{Positive Psychology: AHI CESD corrected data (in long format).}
\format{
A table with 990 cases (rows) and 50 variables (columns).
}
\source{
\strong{Articles}

\itemize{

\item Woodworth, R. J., O’Brien-Malone, A., Diamond, M. R., & Schüz, B. (2017). 
Web-based positive psychology interventions: A reexamination of effectiveness. 
\emph{Journal of Clinical Psychology}, \emph{73}(3), 218--232. 
doi: \code{10.1002/jclp.22328} 

\item Woodworth, R. J., O’Brien-Malone, A., Diamond, M. R. and Schüz, B. (2018). 
Data from, ‘Web-based positive psychology interventions: A reexamination of effectiveness’. 
\emph{Journal of Open Psychology Data}, \emph{6}(1). 
doi: \code{10.5334/jopd.35}
}

See \url{https://openpsychologydata.metajnl.com/articles/10.5334/jopd.35/} for details 
and \url{https://doi.org/10.6084/m9.figshare.1577563.v1} for original dataset. 

Additional references at \url{https://bookdown.org/hneth/ds4psy/B-1-datasets-pos.html}.
}
\usage{
posPsy_long
}
\description{
\code{posPsy_long} is a dataset containing answers to the 24 items of the 
Authentic Happiness Inventory (AHI) and answers to the 
20 items of the Center for Epidemiological Studies Depression (CES-D) scale 
(see Radloff, 1977) for multiple (1 to 6) measurement occasions.
}
\details{
This dataset is a corrected version of \code{\link{posPsy_AHI_CESD}} 
and in long-format.
}
\seealso{
\code{\link{posPsy_AHI_CESD}} for source of this file and codebook information;  
\code{\link{posPsy_wide}} for a version of this file (in wide format).

Other datasets: 
\code{\link{Bushisms}},
\code{\link{Trumpisms}},
\code{\link{countries}},
\code{\link{data_1}},
\code{\link{data_2}},
\code{\link{data_t1_de}},
\code{\link{data_t1_tab}},
\code{\link{data_t1}},
\code{\link{data_t2}},
\code{\link{data_t3}},
\code{\link{data_t4}},
\code{\link{dt_10}},
\code{\link{exp_num_dt}},
\code{\link{exp_wide}},
\code{\link{falsePosPsy_all}},
\code{\link{fame}},
\code{\link{flowery}},
\code{\link{fruits}},
\code{\link{outliers}},
\code{\link{pi_100k}},
\code{\link{posPsy_AHI_CESD}},
\code{\link{posPsy_p_info}},
\code{\link{posPsy_wide}},
\code{\link{t3}},
\code{\link{t4}},
\code{\link{t_1}},
\code{\link{t_2}},
\code{\link{t_3}},
\code{\link{t_4}},
\code{\link{table6}},
\code{\link{table7}},
\code{\link{table8}},
\code{\link{tb}}
}
\concept{datasets}
\keyword{datasets}
