% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text_fun.R
\name{count_chars}
\alias{count_chars}
\title{Count the frequency of characters in a string of text \code{x}.}
\usage{
count_chars(x, case_sense = TRUE, rm_specials = TRUE, sort_freq = TRUE)
}
\arguments{
\item{x}{A string of text (required).}

\item{case_sense}{Boolean: Distinguish lower- vs. uppercase characters? 
Default: \code{case_sense = TRUE}.}

\item{rm_specials}{Boolean: Remove special characters? 
Default: \code{rm_specials = TRUE}.}

\item{sort_freq}{Boolean: Sort output by character frequency? 
Default: \code{sort_freq = TRUE}.}
}
\value{
A named numeric vector.
}
\description{
Count the frequency of characters in a string of text \code{x}.
}
\examples{
# Default: 
x <- c("Hello!", "This is a 1st sentence.", "This is the 2nd sentence.", "The end.")
count_chars(x)

# Options: 
count_chars(x, case_sense = FALSE)
count_chars(x, rm_specials = FALSE)
count_chars(x, sort_freq = FALSE)

}
\seealso{
\code{\link{count_words}} for counting the frequency of words;   
\code{\link{plot_text}} for a corresponding plot function.

Other text objects and functions: 
\code{\link{Umlaut}},
\code{\link{capitalize}()},
\code{\link{caseflip}()},
\code{\link{cclass}},
\code{\link{count_words}()},
\code{\link{l33t_rul35}},
\code{\link{metachar}},
\code{\link{read_ascii}()},
\code{\link{text_to_sentences}()},
\code{\link{text_to_words}()},
\code{\link{transl33t}()}
}
\concept{text objects and functions}
