% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/common.r
\name{polyaxb}
\alias{polyaxb}
\title{Substitute a coefficient of polynomial}
\usage{
polyaxb(coeff, c, a, b)
}
\arguments{
\item{coeff}{A coefficient vector in increasing order of degrees;
the first element is 0th degree, ..., and the last element is the largest
degree of coefficients.}

\item{c}{A multiple factor of constant to be applied to all coefficients.}

\item{a}{A coefficient of 1st degree of \code{a*x + b}.}

\item{b}{A coefficient of 0th degree of \code{a*x + b}.}
}
\value{
A substituted coefficient.
}
\description{
Substitute a coefficient of a polynomial with
\code{a*x + b}.
For a polynomial with a coefficient vector \eqn{poly(x; coeff)},
compute the coefficient vector of
\deqn{poly(a*x + b; coeff).}
}
\examples{
coeff <- c(2, -2, 1)
a <- 1.1
b <- 1.2
coeff1 <- c(b, a)
coeff2 <- polyaxb(coeff, 1, a, b)
xv <- c(1, 2, 3)
## a*x + b
yv1 <- eval_poly(coeff1, xv)
## polynomial(a*x + b, coeff)
yv2 <- eval_poly(coeff, yv1)
## polynomial(x, coeff2)
yv <- eval_poly(coeff2, xv)
## This value is nearly 0 in the presence of rounding errors
yv - yv2
}
\seealso{
\code{\link[=eval_poly]{eval_poly()}}
}
