% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gaussmodel.r
\name{summary.gaussmodel}
\alias{summary.gaussmodel}
\title{Summary of Gaussian-based model \code{gaussmodel} object}
\usage{
\method{summary}{gaussmodel}(object, nmax = 10, estonly = FALSE, ...)
}
\arguments{
\item{object}{\code{gaussmodel} object.}

\item{nmax}{A number of estimates to show in the summary.
The default is 10.}

\item{estonly}{Show only the results of estimates. The default value
is \code{FALSE}.}

\item{...}{Arguments to be passed to or from other methods.}
}
\value{
None.
}
\description{
Summary of \code{gaussmodel} object, including a mean and
a standard deviation and quantiles.
If some estimation has done, also print out estimates, up to \code{nmax}
number of them.
}
\examples{
## Create gaussmodel object from a data set mix2gauss$n200
gmodel <- gaussmodel(mix2gauss$n200)
## Print a summary of an object
summary(gmodel)
}
\seealso{
\code{\link[=gaussmodel]{gaussmodel()}} \code{\link[=plot.gaussmodel]{plot.gaussmodel()}} \code{\link[=estimate.gaussmodel]{estimate.gaussmodel()}}
}
