% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/erf.R
\name{erf}
\alias{erf}
\alias{erfc}
\alias{erfinv}
\alias{erfcinv}
\alias{pnorm}
\alias{qnorm}
\title{erf function}
\usage{
erf(x)

erfc(x)

erfinv(x)

erfcinv(x)

pnorm(q, mean = 0, sd = 1, deriv = 0, log.p = FALSE, lower.tail = TRUE)

qnorm(p, mean = 0, sd = 1, deriv = 0, log.p = FALSE, lower.tail = TRUE)
}
\arguments{
\item{x}{vector of quantiles.}

\item{q}{vector of quantiles.}

\item{mean}{vector of means.}

\item{sd}{vector of standard deviations.}

\item{deriv}{derivative of order \code{deriv}. Available are \code{0} and \code{2}.}

\item{log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are \eqn{P[X \le x]}  otherwise, \eqn{P[X > x]}.}

\item{p}{vector of probabilites.}
}
\value{
Returns a vector of the corresponding function evaluated at x.
}
\description{
Error function, complementary error function, inverse error function,inverse complementary error function and first and second derivative of quantile function of the standard normal distribution.
}
\details{
\code{erf} is the error function. \code{erfc} is the complementary error function.
\code{erfinv} is the inverse error function and and \code{erfcinv} is the inverse complementary error function. \code{pnorm} and \code{qnorm} are clones from
the \code{stats} package, but do have the argument for derivatives.
}
\section{Functions}{
\itemize{
\item \code{erfc()}: complementary error function

\item \code{erfinv()}: inverse error function

\item \code{erfcinv()}: inverse complementary error function

\item \code{pnorm()}: Distribution function of the standard normal distribution with derivatives.

\item \code{qnorm()}: Quantile function of the standard normal distribution with derivatives.

}}
\examples{
erf(0.5)
erfc(0.5)
erfinv(0.5)
erfcinv(0.5)

qnorm(0.5, deriv=2)
pnorm(0.5, deriv=2)

}
