% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix_evaluation.R
\name{h_eval}
\alias{h_eval}
\title{Evaluate H basis}
\usage{
h_eval(k, xd, x, col_idx = NULL)
}
\arguments{
\item{k}{Order for the falling factorial basis. Must be >= 0.}

\item{xd}{Design points. Must be sorted in increasing order, and have length
at least \code{k+1}.}

\item{x}{Query points. Must be sorted in increasing order.}

\item{col_idx}{Vector of indices, a subset of \code{1:n} where \code{n = length(xd)},
that indicates which columns of the constructed matrix should be returned.
The default is \code{NULL}, which is taken to mean \code{1:n}.}
}
\value{
Sparse matrix of dimension \code{length(x)} by \code{length(col_idx)}.
}
\description{
Evaluates the falling factorial basis of a given order, with respect to given
design points, at arbitrary query points.
}
\details{
The falling factorial basis functions of order \eqn{k}, defined with
respect to design points \eqn{x_1 < \ldots < x_n}, are denoted \eqn{h^k_1,
  \ldots, h^k_n}. For their precise definition and further references, see
the help file for \code{\link[=h_mat]{h_mat()}}. The current function produces a matrix of
evaluations of the falling factorial basis at an arbitrary sequence of
query points. For each query point \eqn{x}, this matrix has a corresponding
row with entries:
\deqn{
  h^k_j(x), \; j = 1, \ldots, n.
  }
}
\examples{
xd = 1:10 / 10
x = 1:9 / 10 + 0.05
h_mat(2, xd)
h_eval(2, xd, x)
}
\seealso{
\code{\link[=h_mat]{h_mat()}} for constructing evaluations of the falling factorial
basis at the design points.
}
