% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stack.R
\name{commit}
\alias{commit}
\title{Commit Data to Stack Frame}
\usage{
commit(frame, obj, description = NULL, params = NULL)
}
\arguments{
\item{frame}{A frame you want to commit.}

\item{obj}{A data to commit. Data will be preprocessed by the handler but dependently on auto_push
mode will be sent to server or not. If auto_push is False then the data won't be sent.
Explicit push call need anyway to process committed data. auto_push is useful only in the
case of multiple data objects in the stack frame, e.g. set of plots with settings.}

\item{description}{Description of the data.}

\item{params}{Parameters associated with this data, e.g. plot settings.}
}
\value{
Changed frame.
}
\description{
Function adds a new view to the stack frame.
Multiple views can be added to one frame, but in this case every plot must be supplied with certain parameters
to distiguish one view from another. In the case of single plot parameters are not necessary.
For multiple views parameters will be automaticaly converted to UI controls like sliders and drop down lists.
}
\examples{
\donttest{
library(ggplot2)
library(dstack)
image <- qplot(clarity, data = diamonds, fill = cut, geom = "bar")
frame <- create_frame(stack = "diamonds")
frame <- commit(frame, image, "Diamonds bar chart")
print(push(frame)) # print actual stack URL
}
}
