% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dnumeric.R
\name{dnumeric}
\alias{dnumeric}
\title{Create standard descriptive statistics}
\usage{
dnumeric(data, vnames, neat = TRUE, sizesort = FALSE)
}
\arguments{
\item{data}{a \code{data.frame}}

\item{vnames}{a single variable name to examine with \code{psych::describe}}

\item{neat}{logical, returns rounded values if \code{TRUE}}

\item{sizesort}{logical, returns sorted data by mean if \code{TRUE}}
}
\value{
Returns a \code{data.frame} with common descriptive statistics for a
  numeric variable, as defined in \code{psych::describe}, concatenated with
  the name of the dataset and the name of the variable.
}
\description{
Wrapper for \code{psych::describe} that adds the name of the dataset and the
variable being examined to its output. Use in \code{dtable} for multiple
variables.
}
\examples{
# Single variable
dnumeric(iris2, "Sepal.Length")

# Use \\link{\\code{dtable}} for multiple variables
}
\seealso{
See \code{\link{dtable}}

See \code{\link[psych]{describe}} for more details on the
  descriptive statistics returned
}

