% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dnum.R
\name{dnum}
\alias{dnum}
\title{Create standard descriptive statistics}
\usage{
dnum(data1, neat = TRUE, sizesort = FALSE)
}
\arguments{
\item{data1}{a \code{data.frame} column or columns, or a \code{list}}

\item{neat}{logical, returns rounded values if \code{TRUE}}

\item{sizesort}{logical, returns sorted data by mean if \code{TRUE}}
}
\value{
Returns a \code{data.frame} with common descriptive statistics for a
  numeric variable, as defined in \code{psych::describe}, concatenated with
  the name of the dataset and the name of the variable.
}
\description{
Wrapper for \code{psych::describe} that adds the name of the dataset and the
variable being examined to its output. Used in \code{dtable} for multiple
variables.
}
\examples{

# Single variable
dnum(iris2$Sepal.Length)
dnum(iris2["Sepal.Length"])
dnum(iris2[, "Sepal.Length"])

# Multiple variables
dnum(iris2[, c("Sepal.Length", "Sepal.Width")])

# Will not save you from yourself (will create numeric data for factors):
dnum(iris2$Species)

}
\seealso{
See \code{\link{dtable}}

See \code{\link[psych]{describe}} for more details on the
  descriptive statistics returned
}

