% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_markers_fn.R
\name{find_markers}
\alias{find_markers}
\title{Find marker genes for each cell type.}
\usage{
find_markers(Y, pure_samples, data_type = NULL, gamma = NULL,
  marker_method = "ratio")
}
\arguments{
\item{Y}{The expression matrix. Data frame or matrix. Each row contains expression measurements for a particular sample. Each columm contains the measurements of the same gene over all individuals.}

\item{pure_samples}{The pure sample indicies. List of vectors. The i-th element of the top-level list is a vector of indicies (rows of Y) that are pure samples of type i.}

\item{data_type}{A string indicating the type of the expression measurements. Used to choose pre-estimated gamma value. Current support for probe-level microarray as ``microarray-probe'', gene-level microarray as ``microarray-gene'' or rna-seq as ``rna-seq''.}

\item{gamma}{Expression sensitivity parameter. If provided as a single positive number then that value will be used for gamma and over-ride the value of gamma chosen by the data_type argument.}

\item{marker_method}{The method used to determine which genes are markers. If not supplied defaults to ``ratio''. Options are
\itemize{
\item{'ratio'}{ selects and ranks markers by the ratio of the mean expression of each gene in each cell type to the mean of that gene in all other cell types.}
\item{'regression '}{ selects and ranks markers by estimated regression coefficients in a series of regressions with single covariate that is indicator of each type.}
\item{'diff'}{ selects and ranks markers based upon the difference, for each cell type, between the median expression of a gene by each cell type and the median expression of that gene by the second most highly expressed cell type.}
}}
}
\value{
List with two elements. ``L'' is respective ranked markers for each cell type and ``V'' is the corresponding values of the ranking method (higher are better) used to determine markers and sort them.
}
\description{
Find marker genes for each cell type.
}
\examples{
truth = shen_orr_ex$annotation$mixture
pure_samples <- lapply(1:3, function(i) {
   which(truth[, i] == 1)
})
Y <- shen_orr_ex$data$log
find_markers(Y,pure_samples,data_type='microarray-gene',marker_method='ratio')
}
