% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/complete.R
\name{complete.dtplyr_step}
\alias{complete.dtplyr_step}
\title{Complete a data frame with missing combinations of data}
\usage{
\method{complete}{dtplyr_step}(data, ..., fill = list())
}
\arguments{
\item{data}{A \code{\link[=lazy_dt]{lazy_dt()}}.}

\item{...}{Specification of columns to expand. Columns can be atomic vectors
or lists.
\itemize{
\item To find all unique combinations of \code{x}, \code{y} and \code{z}, including those not
present in the data, supply each variable as a separate argument:
\code{expand(df, x, y, z)}.
\item To find only the combinations that occur in the
data, use \code{nesting}: \code{expand(df, nesting(x, y, z))}.
\item You can combine the two forms. For example,
\code{expand(df, nesting(school_id, student_id), date)} would produce
a row for each present school-student combination for all possible
dates.
}

When used with factors, \code{expand()} uses the full set of levels, not just
those that appear in the data. If you want to use only the values seen in
the data, use \code{forcats::fct_drop()}.

When used with continuous variables, you may need to fill in values
that do not appear in the data: to do so use expressions like
\code{year = 2010:2020} or \code{year = full_seq(year,1)}.}

\item{fill}{A named list that for each variable supplies a single value to
use instead of \code{NA} for missing combinations.}
}
\description{
This is a method for the tidyr \code{complete()} generic. This is a wrapper
around \code{dtplyr} translations for \code{expand()}, \code{full_join()}, and \code{replace_na()}
that's useful for completing missing combinations of data.
}
\examples{
library(tidyr)
tbl <- tibble(x = 1:2, y = 1:2, z = 3:4)
dt <- lazy_dt(tbl)

dt \%>\%
  complete(x, y)

dt \%>\%
  complete(x, y, fill = list(z = 10L))
}
