% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate.R
\name{dtt_aggregate}
\alias{dtt_aggregate}
\alias{dtt_aggregate.Date}
\alias{dtt_aggregate.POSIXct}
\alias{dtt_aggregate.hms}
\title{Aggregate Date/Time}
\usage{
dtt_aggregate(x, units, ...)

\method{dtt_aggregate}{Date}(x, units = "days", ...)

\method{dtt_aggregate}{POSIXct}(x, units = "seconds", ...)

\method{dtt_aggregate}{hms}(x, units = "seconds", ...)
}
\arguments{
\item{x}{A date/time vector.}

\item{units}{A string of the time units. The possible values are "secs",
"minutes", "hours", "days" or "weeks".}

\item{...}{Unused.}
}
\value{
The floored date/time vector.
}
\description{
Aggregates a date/time vector
}
\details{
The possible units values are 'seconds', 'minutes', 'hours', 'days', 'months'
or 'years'.
}
\section{Methods (by class)}{
\itemize{
\item \code{dtt_aggregate(Date)}: Aggregate a Date vector

\item \code{dtt_aggregate(POSIXct)}: Aggregate a POSIXct vector

\item \code{dtt_aggregate(hms)}: Aggregate a hms vector

}}
\examples{
dtt_aggregate(as.Date(c("1992-01-01", "1991-02-02", "1991-03-03")), "years")
}
