% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plot-dtwSat.R
\docType{methods}
\name{plotPath}
\alias{plotPath}
\title{Plotting paths of dtwSat object}
\usage{
plotPath(x, normalize = FALSE, n.alignments = NULL, show.dist = FALSE,
  shift = c(-4, -1))
}
\arguments{
\item{x}{An \code{\link[dtwSat]{dtwSat-class}} object}

\item{normalize}{Plot normalized distance. Default is FALSE}

\item{n.alignments}{A vector. The alignment indices to
plot. NULL will plot all possible alignments}

\item{show.dist}{Display dtw distance for each alignment}

\item{shift}{A vector of length 2. These values shift the position
of the text in \code{x} and \code{y}, respectively. Argument used
with show.dist}
}
\value{
object of class \code{\link[ggplot2]{ggplot}}
}
\description{
Method for plotting the minimum paths in the
cost matrix of Time-Weighted DTW
}
\examples{
names(query.list)
alig = dtwSat(query.list[["Soybean"]], template, weight = "logistic",
       alpha = 0.1, beta = 100, n.alignments = 4, keep = TRUE)
gp = plotPath(alig, normalize=TRUE, show.dist = TRUE)
gp
}
\author{
Victor Maus, \email{vwmaus1@gmail.com}
}
\seealso{
\code{\link[dtwSat]{dtwSat}}, \code{\link[dtwSat]{plotAlignment}},
\code{\link[dtwSat]{plotClassify}}, and \code{\link[dtwSat]{plotCostMatrix}}
}

