% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_time_series.R
\name{prepare_time_series}
\alias{prepare_time_series}
\title{Prepare a Time Series Tibble from a 2D stars Object with Bands and Time Attributes}
\usage{
prepare_time_series(x)
}
\arguments{
\item{x}{A data frame derived from a stars object containing time series data in wide format.
The column names should adhere to one of the following formats: "band.YYYY.MM.DD", "XYYYY.MM.DD.band", or "YYYY.MM.DD.band".}
}
\value{
A nested tibble in wide format. Each row of the tibble corresponds to a unique 'ts_id' that maintains the order from the original stars object.
The nested structure contains observations (time series) for each 'ts_id', including the 'time' of each observation, and individual bands are presented as separate columns.
}
\description{
This function reshapes a data frame, which has been converted from a stars object, into a nested wide tibble format.
The stars object conversion often results in columns named in formats like "band.YYYY.MM.DD", "XYYYY.MM.DD.band", or "YYYY.MM.DD.band".
}
