# Generated by 02-duckplyr_df-methods.R
#' @export
do.duckplyr_df <- function(.data, ...) {
  # Our implementation
  rel_try(
    "No relational implementation for do()" = TRUE,
    {
      return(out)
    }
  )

  # dplyr forward
  do <- dplyr$do.data.frame
  out <- do(.data, ...)
  return(out)

  # dplyr implementation
  args <- enquos(...)
  named <- named_args(args)

  # Create custom data mask with `.` pronoun
  mask <- new_data_mask(new_environment())
  env_bind_do_pronouns(mask, .data)

  if (!named) {
    out <- eval_tidy(args[[1]], mask)
    if (!inherits(out, "data.frame")) {
      msg <- glue("Result must be a data frame, not {fmt_classes(out)}.")
      abort(msg)
    }
  } else {
    out <- map(args, function(arg) list(eval_tidy(arg, mask)))
    names(out) <- names(args)
    out <- tibble::as_tibble(out, .name_repair = "minimal")
  }

  out
}

duckplyr_do <- function(.data, ...) {
  try_fetch(
    .data <- as_duckplyr_df(.data),
    error = function(e) {
      testthat::skip(conditionMessage(e))
    }
  )
  out <- do(.data, ...)
  out
}
