# Generated by 02-duckplyr_df-methods.R
#' @export
rowwise.duckplyr_df <- function(data, ...) {
  # Our implementation
  rel_try(
    # Always fall back to dplyr
    "No relational implementation for rowwise()" = TRUE,
    {
      return(out)
    }
  )

  # dplyr forward
  rowwise <- dplyr$rowwise.data.frame
  out <- rowwise(data, ...)
  return(out)

  # dplyr implementation
  vars <- tidyselect::eval_select(expr(c(...)), data)
  rowwise_df(data, vars)
}

duckplyr_rowwise <- function(data, ...) {
  try_fetch(
    data <- as_duckplyr_df(data),
    error = function(e) {
      testthat::skip(conditionMessage(e))
    }
  )
  out <- rowwise(data, ...)
  class(out) <- setdiff(class(out), "duckplyr_df")
  out
}
