% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertions.R
\name{assert_all_tablenames}
\alias{assert_all_tablenames}
\title{Assert that all names are among names of a \code{list} of \code{data.frame}.}
\usage{
assert_all_tablenames(db, tab, null_ok = TRUE, qualifier = NULL)
}
\arguments{
\item{db}{(\code{list} of \code{data.frame}) input to check for the presence of tables.}

\item{tab}{(\code{character}) the names of the tables to be checked.}

\item{null_ok}{(\code{flag}) can \code{x} be NULL.}

\item{qualifier}{(\code{string}) to be returned if the check fails.}
}
\value{
invisible \code{TRUE} or an error message if the criteria are not fulfilled.
}
\description{
Assert that all names are among names of a \code{list} of \code{data.frame}.
}
\examples{
lsd <- list(
  mtcars = mtcars,
  iris = iris
)
assert_all_tablenames(lsd, c("mtcars", "iris"), qualifier = "first test:")
}
