% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file_create_or_update_request.R
\name{file_create_request}
\alias{file_create_request}
\title{Create object for adding a dataset file.}
\usage{
file_create_request(file_name, url, description = NULL, labels = NULL)
}
\arguments{
\item{file_name}{File name including the file extension. If a file by that name already
exists in the dataset, the file will be updated/overwritten.}

\item{url}{Source URL for file.}

\item{description}{(optional) File description.}

\item{labels}{(optional) List of file labels ("raw data", "documentation",
"visualization", "clean data", "script" or "report").}
}
\value{
Object of type \code{file_create_request}.
}
\description{
Create object for adding a dataset file.
}
\examples{
file_create_req <- dwapi::file_create_request(file_name = "file.csv",
 url = "https://data.world/file.csv",
 description = "My CSV file",
 labels = list("raw data"))
}
\seealso{
\code{\link{create_dataset}}, \code{\link{replace_dataset}}
}
