% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fun.R
\name{Plot}
\alias{Plot}
\alias{plot.ddArray}
\alias{plot.dd}
\alias{plot.fmod}
\alias{plot.polygonLayout}
\alias{plot.layoutSimple}
\alias{plot.psiHat}
\alias{plot.dwphat}
\title{Plot dd and ddArray Objects}
\usage{
\method{plot}{ddArray}(
  x,
  type = "CDF",
  extent = "full",
  distr = "all",
  xmax = NULL,
  resolution = 250,
  mod_highlight = NULL,
  ...
)

\method{plot}{dd}(
  x,
  type = "CDF",
  extent = "full",
  xmax = NULL,
  resolution = 250,
  nsim = 1000,
  CL = 0.9,
  ...
)

\method{plot}{fmod}(x, ...)

\method{plot}{polygonLayout}(x, ...)

\method{plot}{layoutSimple}(x, ...)

\method{plot}{psiHat}(x, ...)

\method{plot}{dwphat}(x, ...)
}
\arguments{
\item{x}{model(s) to plot}

\item{type}{Type or representation of carcass dispersion to plot:
\code{"CDF"}, \code{"PDF"}, or \code{"rcd"}. The \code{"CDF"} gives the
fraction of carcasses falling within \code{r} meters from a turbine and
\code{"PDF"} is the associated probability density. The \code{"rcd"} gives the
relative carcass density at a point \code{r} meters from a turbine and is
PDF/(2 * pi * r).}

\item{extent}{Plot dispersions as fraction of total carcasses (\code{"full"})
or as fraction of carcasses within the searched area (\code{"win"}).}

\item{distr}{vector of names of distributions to plot or \code{set = "all"}}

\item{xmax}{maximum distance to show in the graph; if \code{xmax = NULL}, the
maximum distance is taken as the max distance in the data set to which the
models were fit.}

\item{resolution}{The number of line segments to break the curves into when
plotting (i.e., \code{x = seq(0, xmax, length.out = resolution)}). Higher
resolutions give smoother-looking curves.}

\item{mod_highlight}{Character string giving the name of the model to
highlight by plotting it last and with \code{lwd = 2}. If \code{NULL}, the
curve associated with the lowest (best) AICc score is highlighted.}

\item{...}{arguments that may be passed to plotting functions}

\item{nsim}{Number of simulation reps to use for estimating confidence bounds
for \code{\link[=ddFit]{dd}} plot (ignored for \code{\link[=ddFit]{ddArray}}
objects)}

\item{CL}{confidence level to show in a \code{\link[=ddFit]{dd}} plot (ignored 
for \code{\link[=ddFit]{ddArray}} objects)}
}
\value{
Plot displayed; no return value.
}
\description{
Plot CDF, PDF, or rcd (relative carcass density) for a single
 carcass dispersion glm model (\code{\link[=ddFit]{dd}} object) or a list of 
 models (\code{\link[=ddFit]{ddArray}} object).
}
\details{
\code{\link[=ddFit]{ddArray}} objects are plotted with lines in order 
 of decreasing AICc, so that the "better" models are closer to the top and 
 more prominent. The model with the lowest AICc ("best" model) is plotted 
 last with a heavier line than the others.

 For \code{\link[=ddFit]{dd}} objects, the curve for the MLE of the parameters
 is plotted, along with a 100\code{CL}\% confidence bounds determined for 
 \code{nsim} simulation reps

 The legend follows the ordering given by \code{\link{modelFilter}} with 
 the default sieve or, if \code{extent = "win"} by (1) delta AICc < 10, 
 (2) the absence of high-influence points, and (2) AICc. The best model 
 according to the filter is listed first, with a heavier line than the others; 
 the remaining distributions are listed in descending order, with the best 
 models in the leftmost column.
}
