% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{cofOK}
\alias{cofOK}
\alias{cofOK0}
\alias{cofOKInf}
\title{Check Whether GLM Coefficients Give Proper Distribution}
\usage{
cofOK(cof, distr)

cofOK0(cof, distr)

cofOKInf(cof, distr)
}
\arguments{
\item{cof}{vector or matrix of named glm parameters (with \code{"r"} as the
distance variable)}

\item{distr}{name of the distribution}
}
\value{
boolean vector (or scalar)
}
\description{
In order for a fitted GLM to convert to a proper distance distribution, its
integral from 0 to Inf must be finite. As a rule, when the leading coefficient 
is positive, the integral diverges as the upper bound of integration approaches
infinity, and \code{cofOK} would return \code{FALSE}. Likewise, in some cases,
the GLM coefficients yield an integral that diverges as the lower bound 
approaches 0, in which case \code{cofOK} returns \code{FALSE} as well. 
\code{cofOK0} and \code{cofOKInf} check the left and right tails of the 
candidate distribution, repectively, for convergence.
}
