#' Ratings of relational satisfaction and commitment from 282 (Q)ueer couples
#'
#'A data set containing 5 ratings of satisfaction and 5 ratings of commitment for each
#'member of a dyad in which one or more members identify as LGBTQ+. Measured using the Investment Model Scale subscales
#'(Rusbult, Martz, & Agnew, 1998). Data are from Sakaluk, Fisher, and Kilshaw (2021).
#'Variable names follow a stem-partner-item ("spi") order, with a delimiter (".") between
#'the stem and distinguishing partner character, and another delimiter ("_") between the
#'distinguishing partner character and item number.
#'
#' @docType data
#'
#' @usage data(commitmentQ)
#'
#' @format A data frame with 118 rows and 20 variables:
#' \describe{
#'  \item{sat.g.1_1}{Satisfaction item 1 for partner1}
#'  \item{sat.g.1_2}{Satisfaction item 2 for partner1}
#'  \item{sat.g.1_3}{Satisfaction item 3 for partner1}
#'  \item{sat.g.1_4}{Satisfaction item 4 for partner1}
#'  \item{sat.g.1_5}{Satisfaction item 5 for partner1}
#'  \item{com.1_1}{Commitment items item 1 for partner1}
#'  \item{com.1_2}{Commitment items item 2 for partner1}
#'  \item{com.1_3}{Commitment items item 3 for partner1}
#'  \item{com.1_4}{Commitment items item 4 for partner1}
#'  \item{com.1_5}{Commitment items item 5 for partner1}
#'  \item{sat.g.2_1}{Satisfaction item 1 for partner 2}
#'  \item{sat.g.2_2}{Satisfaction item 2 for partner 2}
#'  \item{sat.g.2_3}{Satisfaction item 3 for partner 2}
#'  \item{sat.g.2_4}{Satisfaction item 4 for partner 2}
#'  \item{sat.g.2_5}{Satisfaction item 5 for partner 2}
#'  \item{com.2_1}{Commitment items item 1 for partner 2}
#'  \item{com.2_2}{Commitment items item 2 for partner 2}
#'  \item{com.2_3}{Commitment items item 3 for partner 2}
#'  \item{com.2_4}{Commitment items item 4 for partner 2}
#'  \item{com.2_5}{Commitment items item 5 for partner 2}
#' }
#'
#'@references Sakaluk, J. K., Fisher, A. N., & Kilshaw, R. E.(2021). Dyadic measurement invariance and its importance for replicability in romantic relationship research. *Personal Relationships*, *28*(1), 190-226.  .#'
#'
"commitmentQ"
