% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Fun_Calib-assist.R
\name{calib_assist}
\alias{calib_assist}
\title{Assist calibration of DYRESM-CAEDYM model. Before using this function, make sure that you have set up "Bin" and "Files" sub-folders under the DYCD model folder.}
\usage{
calib_assist(
  cal.para,
  combination = "random",
  n,
  model.var,
  phyto.group = NA,
  obs.data,
  objective.function = c("NSE", "RMSE"),
  start.date,
  end.date,
  dycd.wd,
  dycd.output,
  file.name,
  verbose = TRUE,
  parallel = FALSE,
  n.cores = NULL,
  write.out = TRUE
)
}
\arguments{
\item{cal.para}{a data frame or a character string naming an external .csv file where below columns are included:
"Parameter" where parameter names (abbreviation is allowed),
"Min", "Max", and "Increment" describing the minimum and maximum parameter values and expected increment in the value range,
"Input_file" and "Line_NO" listing in which configuration file at which line can the parameter can be found.}

\item{combination}{a vector of string character of how to pick up combinations of parameter values."random" - the function randomly
picks up given number of combinations; "all" - the function tries all possible combinations of parameter values.}

\item{n}{the number of randomly selections. Must be provided if combination = "random".}

\item{model.var}{a vector of string character of modelled variables for calibration.
If the chlorophyll of multiple phytoplankton groups is used collectively for calibration, use "CHLA" and further specify which phytoplankton groups are to be combined in the argument of "phyto.group".
If phytoplankton groups are separately calibrated, list their abbreviation in this argument. Five abbreviations are supported: CHLOR, FDIAT, NODUL, CYANO and CRYPT.}

\item{phyto.group}{a vector of simulated phytoplankton groups, including CHLOR, FDIAT, NODUL, CYANO and CRYPT.}

\item{obs.data}{a character string naming a file of observed lake data. This file needs to be prepared in a given format (see example data).}

\item{objective.function}{a vector of string character claiming what objective function(s) to be used for calibration.
Selected from the following five functions: "NSE": Nash-Sutcliffe efficiency coefficient, "RMSE": Root Mean Square Error,
   "MAE": Mean Absolute Error, "RAE": Relative Absolute Error, "Pearson": Pearson's r.}

\item{start.date, end.date}{the beginning and ending simulation dates for the intended DYRESM-CAEDYM calibration. The date format must be "\%Y-\%m-\%d".}

\item{dycd.wd}{the directory where input files (including the bat file) to DYRESM-CAEDYM are stored. either relative or absolute path is allowed.}

\item{dycd.output}{a character string naming the output file of the model calibration.}

\item{file.name}{a character string naming a .csv file for writing out the auto-calibration results.}

\item{verbose}{if TRUE, the auto-calibration information is printed.}

\item{parallel}{if TRUE, the calibration process can be run on multiple cores.}

\item{n.cores}{When parallel is TRUE, n.cores is the number of cores the calibration function will be run on. If not provided,
the default value is the number of available cores on the computer -1.}

\item{write.out}{if TRUE, the auto-calibration results are saved a file with a file name set by the "file.name" argument.}
}
\value{
a dataframe of trialed values of parameters and corresponding values of objective function(s).
}
\description{
This function tries different combinations of selected parameter values and
  outputs corresponding values of fit-of-goodness by calculating some objective functions.
  Then users can choose the optimal set of parameter values to calibrate the model.
}
\note{
No executable examples are provided to illustrate the use of this function, as this function relies on the DYRESM-CAEDYM executables to work.
}
