% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dispatch.R
\docType{class}
\name{LogDispatch}
\alias{LogDispatch}
\title{Log Dispatch}
\description{
R6 Class that dispatches log messages throughout the application.
}
\details{
This object is designed to a centralized logging dispatcher that
renders log messages with the appropriate context of the calling
object. The \code{log_layout()} object is used to generate log message
layouts (render formats), which are used by the \code{LogDispatcher}
to render highly-customizable and detailed log messages.
}
\seealso{
Other Logging: 
\code{\link{get_configurations}()},
\code{\link{init_logger}()}
}
\concept{Logging}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{LogDispatch$new()}}
\item \href{#method-attach_log_level}{\code{LogDispatch$attach_log_level()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of a log config.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LogDispatch$new()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A new \code{LogLayout} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-attach_log_level"></a>}}
\if{latex}{\out{\hypertarget{method-attach_log_level}{}}}
\subsection{Method \code{attach_log_level()}}{
Attaches a S3 \code{log_level} object to the log
dispatcher by creating a new function wrapping the
specified log level, and binding and instance
of the dispatcher quote block with
the context of the log level.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LogDispatch$attach_log_level(log_level)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{log_level}}{log level to attach}
}
\if{html}{\out{</div>}}
}
}
}
