/*
 * Decompiled with CFR 0.152.
 */
package dyn;

import actions.PanelMouseActionListener;
import don.Continue;
import don.ContinueAnalysee;
import don.DonneeID;
import don.DonneeParse;
import don.Groupe;
import don.Individu;
import don.Modalite;
import don.Nominale;
import don.Variable;
import drawing.Canvas;
import drawing.Couleur;
import drawing.Series;
import exceptions.ExceptionIntegrite;
import ihm.FenetreErreur;
import ihm.Gestionnaire;
import ihm.Habilleur;
import ihm.IHM;
import java.awt.Color;
import java.awt.Shape;
import java.util.HashMap;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.Vector;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.annotations.XYIDAnnotation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import outils.Constantes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Graphe {
    public static final PlotOrientation DEFAULT_ORIENTATION = PlotOrientation.VERTICAL;
    private SortedSet<Series> m_donCourante;
    private PlotOrientation m_orientation;
    private String m_titreGraphe;
    private String m_titreX;
    private String m_titreY;
    protected Gestionnaire m_gestionnaire;
    protected Canvas m_canvas;
    protected XYDataset m_data;
    protected Habilleur m_habilleur;
    private HashMap<Nominale, Color> m_tabCoulNom;
    private int m_nbSeriesTraitees;

    public Graphe(Gestionnaire gest, Habilleur hab, String titreGraphe, String titreX, String titreY) {
        this.m_gestionnaire = gest;
        this.m_habilleur = hab;
        this.m_titreGraphe = titreGraphe;
        this.m_titreX = titreX;
        this.m_titreY = titreY;
        this.m_orientation = DEFAULT_ORIENTATION;
    }

    public void affGrid() {
        XYPlot plot = (XYPlot)this.m_gestionnaire.getPanel().getChart().getPlot();
        if (this.m_gestionnaire.isAffGrid()) {
            plot.setDomainGridlinesVisible(true);
            plot.setRangeGridlinesVisible(true);
        } else {
            plot.setDomainGridlinesVisible(false);
            plot.setRangeGridlinesVisible(false);
        }
    }

    protected void affAnnotation(Vector<DonneeID> liste) {
        this.setCanvas();
        XYPlot plot = (XYPlot)this.m_gestionnaire.getPanel().getChart().getPlot();
        AbstractXYItemRenderer renderer = (AbstractXYItemRenderer)plot.getRenderer();
        if (this.m_gestionnaire.getCanvas() != null) {
            this.m_gestionnaire.getCanvas().clearAnnot();
        }
        renderer.removeAnnotations();
        if (this.m_data.getSeriesCount() != 0) {
            for (DonneeID id : liste) {
                if (!this.m_gestionnaire.isAnnotations(id) || this.m_gestionnaire.isFantome(id)) continue;
                ContinueAnalysee axeX = this.m_gestionnaire.getAxeX();
                ContinueAnalysee axeY = this.m_gestionnaire.getAxeY();
                double x = id.getCoord(axeX);
                double y = id.getCoord(axeY);
                XYIDAnnotation annot = new XYIDAnnotation(id.getAnnotation(), id.getXannot(axeX, axeY), id.getYannot(axeX, axeY), x, y, this.getCouleur(id));
                this.m_habilleur.setFont(annot, id);
                annot.setTextAnchor(id.getAnchor());
                renderer.addAnnotation(annot);
                this.m_canvas.addAnnot(annot);
            }
        }
    }

    public void affAnnotation() {
        Vector<DonneeID> liste = new Vector<DonneeID>();
        for (Series s : this.getDonnee()) {
            int i = 0;
            while (i < s.getNbDonneeID()) {
                liste.add(s.getDonneeID(i));
                ++i;
            }
        }
        this.affAnnotation(liste);
    }

    protected Color getCouleur(DonneeID obj) {
        for (Series s : this.getDonnee()) {
            int i = 0;
            while (i < s.getNbDonneeID()) {
                if (s.getDonneeID(i).equals(obj)) {
                    return (Color)s.getColor();
                }
                ++i;
            }
        }
        new FenetreErreur("impossible de trouver la s\u00e9rie de " + obj);
        return Color.red;
    }

    public void update(SortedSet<Series> series) {
        try {
            ChartPanel chartPanel = this.m_gestionnaire.getPanel();
            if (chartPanel == null) {
                chartPanel = new ChartPanel(new JFreeChart(new XYPlot()));
                chartPanel.addChartMouseListener(new PanelMouseActionListener(this.m_gestionnaire, chartPanel));
                this.m_gestionnaire.setPanel(chartPanel);
            } else {
                this.updateCanvas();
            }
            this.setDonnee(series);
            this.m_data = this.construireSeries();
            this.metEnFormeSeries();
            JFreeChart chart = this.createChart(this.m_data);
            chart.setRapport(this.m_gestionnaire.getRapport());
            chartPanel.setChart(chart);
            XYPlot plot = (XYPlot)chart.getPlot();
            ((NumberAxis)plot.getDomainAxis()).setNumberFormatOverride(Constantes.FORMAT_NOMBRES);
            chartPanel.setDomainZoomable(true);
            chartPanel.setRangeZoomable(true);
            plot.setRangeZeroBaselineVisible(true);
            plot.useEqualAxes(this.m_gestionnaire.isOrtho());
            int type = this.m_gestionnaire.getType();
            plot.setUseSquaredAndCenteredArea(type == 2 || type == 1 || type == 3);
            this.m_gestionnaire.setCanvas(this.m_canvas);
            this.affAnnotation();
            this.affGrid();
            this.renderer();
        }
        catch (Exception e) {
            new FenetreErreur(e);
        }
    }

    protected abstract XYDataset construireSeries();

    protected abstract JFreeChart createChart(XYDataset var1);

    protected boolean setCanvas() {
        if (this.m_gestionnaire != null) {
            if (this.m_gestionnaire.getCanvas() == null) {
                this.m_gestionnaire.setCanvas(new Canvas());
            }
            this.m_canvas = this.m_gestionnaire.getCanvas();
            return this.m_canvas != null;
        }
        return false;
    }

    protected boolean updateCanvas() {
        if (this.m_canvas != null) {
            this.m_canvas.clearAnnot();
            this.m_canvas.clearBranche();
            this.m_canvas.clearPoint();
            return true;
        }
        return false;
    }

    protected String getTitreGraphe() {
        return this.m_titreGraphe;
    }

    protected void setTitreGraphe(String titreGraphe) {
        this.m_titreGraphe = titreGraphe;
    }

    protected String getTitreX() {
        return this.m_titreX;
    }

    protected void setTitreX(String titreX) {
        this.m_titreX = titreX;
    }

    protected String getTitreY() {
        return this.m_titreY;
    }

    protected void setTitreY(String titreY) {
        this.m_titreY = titreY;
    }

    protected SortedSet<Series> getDonnee() {
        return this.m_donCourante;
    }

    protected void setDonnee(SortedSet<Series> series) throws ExceptionIntegrite {
        Iterator ite = series.iterator();
        Vector<String> labels = new Vector<String>();
        while (ite.hasNext()) {
            Series serie = (Series)ite.next();
            String label = serie.getSemantique();
            if (!labels.contains(label)) {
                labels.add(label);
                continue;
            }
            throw new ExceptionIntegrite("Nom de s\u00e9rie redondant : " + label);
        }
        this.m_donCourante = series;
    }

    protected void setOrientation(PlotOrientation orientation) {
        this.m_orientation = orientation;
    }

    protected PlotOrientation getOrientation() {
        return this.m_orientation;
    }

    protected void renderer() {
        XYPlot plot = (XYPlot)this.m_gestionnaire.getPanel().getChart().getPlot();
        AbstractXYItemRenderer renderer = (AbstractXYItemRenderer)plot.getRenderer();
        Iterator ite = this.getDonnee().iterator();
        int nbSerie = 0;
        while (ite.hasNext()) {
            Series s = (Series)ite.next();
            if (s.isFantome(this.m_gestionnaire)) continue;
            renderer.setSeriesPaint(nbSerie, s.getColor());
            renderer.setSeriesShape(nbSerie, s.getForme());
            renderer.setSeriesVisibleInLegend(nbSerie, s.isAffLegende());
            if (renderer instanceof XYLineAndShapeRenderer) {
                ((XYLineAndShapeRenderer)renderer).setSeriesShapesFilled(nbSerie, s.isFormePleine());
            }
            ++nbSerie;
        }
    }

    protected void metEnFormeSeries() {
        this.m_nbSeriesTraitees = 0;
        Iterator ite = this.getDonnee().iterator();
        Couleur c = new Couleur();
        this.m_tabCoulNom = new HashMap();
        while (ite.hasNext()) {
            Series s = (Series)ite.next();
            DonneeID don = s.getDonneeID(0);
            s.setForme(this.donneFormeSerie(don));
            s.setColor(this.donneCouleurSerie(c, s, don));
            s.setAffLegende(this.donneAffLegendeSerie(s, don));
        }
    }

    private boolean donneAffLegendeSerie(Series s, DonneeID don) {
        String cde = s.getSemantique();
        Continue habillageContinu = this.m_habilleur.getHabillageContinu(don);
        boolean setAffLegend = !(cde.contains(String.valueOf(IHM.getXmlLangue().hashCode())) || habillageContinu != null && this.m_habilleur.isHabillageCentre(don) || this.m_gestionnaire.getType() != 4 && this.m_habilleur.isSousSeuilAffinage(don));
        return setAffLegend;
    }

    private Color donneCouleurSerie(Couleur c, Series s, DonneeID don) {
        Color couleur;
        String cde = s.getSemantique();
        Continue habillageContinu = this.m_habilleur.getHabillageContinu(don);
        if (cde.contains(String.valueOf(IHM.getXmlLangue().hashCode()))) {
            couleur = Constantes.COULEUR_SELECTION;
            s.setAffLegende(false);
        } else if (this.m_gestionnaire.getType() != 4 && this.m_habilleur.isSousSeuilAffinage(don)) {
            couleur = Constantes.COULEUR_HABILLAGE_CONTINUE_ZERO;
        } else if (habillageContinu != null && this.m_habilleur.isHabillageCentre(don)) {
            couleur = habillageContinu.getValeur(don) > 0.0 ? Constantes.COULEUR_HABILLAGE_CONTINUE_POSITIF : (habillageContinu.getValeur(don) < 0.0 ? Constantes.COULEUR_HABILLAGE_CONTINUE_NEGATIF : Constantes.COULEUR_HABILLAGE_CONTINUE_ZERO);
            s.setAffLegende(false);
        } else {
            couleur = c.getColor(this.m_nbSeriesTraitees);
            Variable habillageDiscret = this.m_habilleur.getHabillageDiscret(don);
            if (don instanceof Variable) {
                couleur = habillageDiscret == null ? (don.isActive() ? Constantes.COULEUR_VARIABLES_ACTIVES : Constantes.COULEUR_VARIABLES_ILLUSTRATIVES) : c.getColor(don.getGr().getNum());
            } else if (don instanceof Individu && habillageDiscret == null && (habillageContinu == null || this.m_habilleur.getHabillageStyleContinu(don) != 0)) {
                couleur = don.isActive() ? Constantes.COULEUR_INDIVIDUS_ACTIFS : Constantes.COULEUR_INDIVIDUS_ILLUSTRATIFS;
            } else if (don instanceof Groupe) {
                couleur = don.isActive() ? Constantes.COULEUR_GROUPES_ACTIFS : Constantes.COULEUR_GROUPES_ILLUSTRATIFS;
            } else if (don instanceof Modalite) {
                Nominale nom = ((Modalite)don).getNominale();
                if (this.m_tabCoulNom.containsKey(nom)) {
                    couleur = this.m_tabCoulNom.get(nom);
                } else if (this.m_gestionnaire.getDon().getType() == DonneeParse.TypeAnalyse.CA) {
                    couleur = don.isActive() ? (nom.getAnnotation().equals("row") ? Constantes.COULEUR_AC_LIGNE_ACTIVE : Constantes.COULEUR_AC_COLONNE_ACTIVE) : (nom.getAnnotation().equals("row") ? Constantes.COULEUR_AC_LIGNE_ILLUSTRATIVE : Constantes.COULEUR_AC_COLONNE_ILLUSTRATIVE);
                } else {
                    couleur = c.getColor(this.m_nbSeriesTraitees);
                    ++this.m_nbSeriesTraitees;
                    this.m_tabCoulNom.put(nom, couleur);
                }
            } else {
                ++this.m_nbSeriesTraitees;
            }
        }
        return couleur;
    }

    private Shape donneFormeSerie(DonneeID don) {
        Shape forme = this.m_gestionnaire.getType() != 4 && this.m_habilleur.isSousSeuilAffinage(don) ? Constantes.FORME_ELEMENT_SOUS_SEUIL_AFFINAGE : (don instanceof Individu ? Constantes.FORME_INDIVIDUS : (don instanceof Modalite ? Constantes.FORME_MODALITES : (don instanceof Groupe ? (don.isActive() ? Constantes.FORME_GROUPES_ACTIFS : Constantes.FORME_GROUPES_ILLUSTRATIFS) : Constantes.FORME_INDIVIDUS)));
        return forme;
    }
}

