/*
 * Decompiled with CFR 0.152.
 */
import don.AxePartiel;
import don.ContinueAnalysee;
import don.ContinueMoyenne;
import don.Dimension;
import don.DonneeParse;
import don.Groupe;
import don.Individu;
import don.IndividuMoyen;
import don.Modalite;
import don.ModaliteMoyenne;
import don.Nominale;
import drawing.Registre;
import ihm.FenetreErreur;
import ihm.IHM;
import java.io.File;
import outils.Fichier;

public class parse {
    private DonneeParse m_don;
    private String[] m_annotColName;
    private int num_groupe_courant = 1;
    private IndividuMoyen m_individuMoyen_old;
    private ContinueMoyenne m_variableMoyenne_old;
    private ModaliteMoyenne m_modaliteMoyenne_old;

    public parse(String[] colName, String dir) {
        this(colName, null, dir);
    }

    public parse(String[] colName, String[] annotColName, String dir) {
        try {
            IHM.m_dir = dir;
            this.m_don = new DonneeParse(colName, 0);
            this.m_don.setColName(colName);
            if (annotColName != null && annotColName.length > 1) {
                this.m_annotColName = new String[annotColName.length - 1];
                int i = 0;
                while (i < annotColName.length - 2) {
                    this.m_annotColName[i] = annotColName[i + 1];
                    this.m_don.addNominale(new Nominale(this.m_annotColName[i]));
                    ++i;
                }
            }
        }
        catch (Exception e) {
            FenetreErreur.display(e);
        }
    }

    public void setType(String t) {
        if (t.equals("PCA")) {
            this.m_don.setType(DonneeParse.TypeAnalyse.PCA);
        } else if (t.equals("MCA")) {
            this.m_don.setType(DonneeParse.TypeAnalyse.MCA);
        } else if (t.equals("MFA")) {
            this.m_don.setType(DonneeParse.TypeAnalyse.MFA);
        } else if (t.equals("CA")) {
            this.m_don.setType(DonneeParse.TypeAnalyse.CA);
        } else if (t.equals("AFDM")) {
            this.m_don.setType(DonneeParse.TypeAnalyse.AFDM);
        } else if (t.equals("dataframe")) {
            this.m_don.setType(DonneeParse.TypeAnalyse.DATAFRAME);
        } else {
            this.m_don.setType(DonneeParse.TypeAnalyse.DATAFRAME);
        }
    }

    public void addHabVal(String[] val) {
        try {
            String annot = val[0];
            Individu donnee = this.m_don.getIndividu(annot);
            if (donnee == null) {
                FenetreErreur.display("impossible de trouver la donn\u00e9e \"" + annot + "\"");
            } else {
                int i = 0;
                while (i < val.length - 2) {
                    if (!val[i + 1].equals("NA")) {
                        Modalite mod = this.m_don.getModalite(val[i + 1]);
                        if (mod != null) {
                            donnee.addModalite(mod);
                        } else {
                            FenetreErreur.display("impossible de trouver la modalit\u00e9 : \"" + val[i + 1] + "\"\n");
                        }
                    } else {
                        FenetreErreur.display("la case " + (i + 1) + " / " + val.length + " du tableau d'annotations est vide");
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            FenetreErreur.display(e);
        }
    }

    public void addVal(String annot, double[] val) {
        try {
            if (annot == null) {
                throw new Exception("Annotation nulle");
            }
            if (this.m_don.getNbAxe() == 0) {
                this.m_don.setNbAxe((int)val[2]);
            }
            String I = String.valueOf((int)val[0]);
            char[] Tval = I.toCharArray();
            String T = String.valueOf(Tval[0]);
            String T2 = I.substring(1);
            if (val[0] == 1.0) {
                if ((int)val[1] == 0) {
                    this.m_individuMoyen_old = new IndividuMoyen(annot, true, this.m_don.getGroupe((int)val[1]), this.getCoord(val), this.getCos2(val), this.getContrib(val), this.getZ(val));
                    this.m_don.addIndividuMoyen(this.m_individuMoyen_old);
                } else {
                    Individu donIndiv = new Individu(annot, true, this.m_don.getGroupe((int)val[1]), this.getCoord(val), this.getCos2(val), this.getContrib(val), this.getZ(val));
                    donIndiv.setPere(this.m_individuMoyen_old);
                }
            } else if (val[0] == 2.0) {
                if ((int)val[1] == 0) {
                    this.m_individuMoyen_old = new IndividuMoyen(annot, false, this.m_don.getGroupe((int)val[1]), this.getCoord(val), this.getCos2(val), this.getContrib(val), this.getZ(val));
                    this.m_don.addIndividuMoyen(this.m_individuMoyen_old);
                } else {
                    Individu donIndiv = new Individu(String.valueOf(annot) + "(" + val[2] + ")", false, this.m_don.getGroupe((int)val[1]), this.getCoord(val), this.getCos2(val), this.getContrib(val), this.getZ(val));
                    donIndiv.setPere(this.m_individuMoyen_old);
                }
            } else if (val[0] == 3.0) {
                this.m_variableMoyenne_old = new ContinueMoyenne(annot, true, this.m_don.getGroupe((int)val[1]), this.getCoord(val), this.getCos2(val), this.getContrib(val), true);
                this.m_don.addContinueMoyenne(this.m_variableMoyenne_old);
            } else if (val[0] == 4.0) {
                this.m_variableMoyenne_old = this.m_don.getType() == DonneeParse.TypeAnalyse.MCA ? new ContinueMoyenne(annot, false, this.m_don.getGroupe((int)val[1]), this.getCoord(val), null, null, true) : new ContinueMoyenne(annot, false, this.m_don.getGroupe((int)val[1]), this.getCoord(val), this.getCos2(val), this.getContrib(val), true);
                this.m_don.addContinueMoyenne(this.m_variableMoyenne_old);
            } else if (val[0] == 5.0) {
                this.m_variableMoyenne_old = new ContinueMoyenne(annot, true, this.m_don.getGroupe((int)val[1]), this.getCoord(val), this.getCos2(val), this.getContrib(val), false);
                this.m_don.addContinueMoyenne(this.m_variableMoyenne_old);
            } else if (val[0] == 6.0) {
                this.m_variableMoyenne_old = this.m_don.getType() == DonneeParse.TypeAnalyse.MCA ? new ContinueMoyenne(annot, false, this.m_don.getGroupe((int)val[1]), this.getCoord(val), null, null, false) : new ContinueMoyenne(annot, false, this.m_don.getGroupe((int)val[1]), this.getCoord(val), this.getCos2(val), this.getContrib(val), false);
                this.m_don.addContinueMoyenne(this.m_variableMoyenne_old);
            } else if (T.compareTo("7") == 0) {
                Nominale nom = this.m_don.getNominale(Integer.valueOf(T2) - 1);
                if ((int)val[1] == 0) {
                    this.m_modaliteMoyenne_old = new ModaliteMoyenne(nom, annot, true, this.m_don.getGroupe((int)val[1]), this.getCoord(val), this.getCos2(val), this.getContrib(val), 0);
                    nom.addModaliteMoyenne(this.m_modaliteMoyenne_old);
                } else {
                    this.m_modaliteMoyenne_old.addBranche(new Modalite(nom, annot, true, this.m_don.getGroupe((int)val[1]), this.getCoord(val), this.getCos2(val), this.getContrib(val), 0));
                }
            } else if (T.compareTo("8") == 0) {
                Nominale nom = this.m_don.getNominale(Integer.valueOf(T2) - 1);
                if ((int)val[1] == 0) {
                    this.m_modaliteMoyenne_old = new ModaliteMoyenne(nom, annot, false, this.m_don.getGroupe((int)val[1]), this.getCoord(val), this.getCos2(val), this.getContrib(val), 0);
                    nom.addModaliteMoyenne(this.m_modaliteMoyenne_old);
                } else {
                    this.m_modaliteMoyenne_old.addBranche(new Modalite(nom, annot, false, this.m_don.getGroupe((int)val[1]), this.getCoord(val), this.getCos2(val), this.getContrib(val), 0));
                }
            } else if (val[0] == 9.0) {
                Groupe g = this.m_don.getGroupe(this.num_groupe_courant);
                g.setAnnotation(annot);
                g.setActive(true);
                g.setCoord(this.getCoord(val));
                g.setContrib(this.getContrib(val));
                g.setCos2(this.getCos2(val));
                ++this.num_groupe_courant;
            } else if (val[0] == 10.0) {
                Groupe g = this.m_don.getGroupe(this.num_groupe_courant);
                g.setAnnotation(annot);
                g.setActive(false);
                g.setCoord(this.getCoord(val));
                g.setContrib(this.getContrib(val));
                g.setCos2(this.getCos2(val));
                ++this.num_groupe_courant;
            } else if (val[0] == 0.0) {
                if ((int)val[1] == 0) {
                    this.m_don.setInerties(this.getCoord(val));
                } else {
                    AxePartiel axePart = new AxePartiel(annot, true, this.m_don.getGroupe((int)val[1]), this.getCoord(val), this.getCos2(val), this.getContrib(val), true);
                    this.m_don.addAxePartiel(axePart);
                }
            } else {
                FenetreErreur.display("donn\u00e9e illisible");
            }
        }
        catch (Exception e) {
            FenetreErreur.display(e);
        }
    }

    public void generate() {
        try {
            this.m_don.verifierIntegrite();
            this.serialiser(String.valueOf(IHM.m_dir) + "tmp.ser");
            File fichier = new File(String.valueOf(IHM.m_dir) + "tmp.ser");
            if (fichier.exists()) {
                String commande = "java -jar " + IHM.m_dir + "dynGraph.jar " + IHM.m_dir + " " + IHM.m_dir + "tmp.ser -t";
                Runtime.getRuntime().exec(commande);
            } else {
                FenetreErreur.display("fichier temporaire introuvable !");
            }
        }
        catch (Exception e) {
            FenetreErreur.display(e);
        }
    }

    public void serialiser(String chemin) {
        try {
            Registre reg = new Registre(this.m_don);
            Fichier.serialiser(reg, chemin);
        }
        catch (Exception e) {
            FenetreErreur.display(e);
        }
    }

    public void serialiser() {
        this.serialiser(String.valueOf(IHM.m_dir) + "/jeudedonnees.ser");
    }

    public void fenetre() {
        try {
            FenetreErreur.display("contenu:\n\n" + this.m_don.toString());
        }
        catch (Exception e) {
            FenetreErreur.display(e);
        }
    }

    public void add_description_dim_par_mod(int num, String nom_modalite_qui_caracterise, double vtest) {
        try {
            Dimension dim = this.m_don.getAxe(num - 1);
            Modalite mod_qui_caracterise = this.m_don.getModalite(nom_modalite_qui_caracterise);
            if (mod_qui_caracterise == null) {
                throw new Exception(String.valueOf(nom_modalite_qui_caracterise) + " inconnue");
            }
            dim.setDescMod(mod_qui_caracterise, vtest);
        }
        catch (Exception e) {
            FenetreErreur.display(e);
        }
    }

    public void add_description_dim_par_cont(int num, String nom_continue_qui_caracterise, double vtest) {
        try {
            Dimension dim = this.m_don.getAxe(num - 1);
            ContinueAnalysee cont_qui_caracterise = this.m_don.getContinue(nom_continue_qui_caracterise);
            if (cont_qui_caracterise == null) {
                throw new Exception(String.valueOf(nom_continue_qui_caracterise) + " inconnue");
            }
            dim.setDescCont(cont_qui_caracterise, vtest);
        }
        catch (Exception e) {
            FenetreErreur.display(e);
        }
    }

    public void add_description_dim_par_nom(int num, String nom_nominale_qui_caracterise, double vtest) {
        try {
            Dimension dim = this.m_don.getAxe(num - 1);
            Nominale nom_qui_caracterise = this.m_don.getNominale(nom_nominale_qui_caracterise);
            if (nom_qui_caracterise == null) {
                throw new Exception(String.valueOf(nom_nominale_qui_caracterise) + " inconnue");
            }
            dim.setDescNom(nom_qui_caracterise, vtest);
        }
        catch (Exception e) {
            FenetreErreur.display(e);
        }
    }

    public void add_description_mod_par_mod(String nom_modalite_a_caracteriser, String nom_modalite_qui_caracterise, double vtest) {
        try {
            Modalite mod_a_caracteriser = this.m_don.getModalite(nom_modalite_a_caracteriser);
            if (mod_a_caracteriser == null) {
                throw new Exception(String.valueOf(nom_modalite_a_caracteriser) + " inconnue");
            }
            Modalite mod_qui_caracterise = this.m_don.getModalite(nom_modalite_qui_caracterise);
            if (mod_qui_caracterise == null) {
                throw new Exception(String.valueOf(nom_modalite_qui_caracterise) + " inconnue");
            }
            mod_a_caracteriser.setDescMod(mod_qui_caracterise, vtest);
        }
        catch (Exception e) {
            FenetreErreur.display(e);
        }
    }

    public void add_description_mod_par_cont(String nom_modalite_a_caracteriser, String nom_continue_qui_caracterise, double vtest) {
        try {
            Modalite mod_a_caracteriser = this.m_don.getModalite(nom_modalite_a_caracteriser);
            if (mod_a_caracteriser == null) {
                throw new Exception(String.valueOf(nom_modalite_a_caracteriser) + " inconnue");
            }
            ContinueAnalysee cont_qui_caracterise = this.m_don.getContinue(nom_continue_qui_caracterise);
            if (cont_qui_caracterise == null) {
                throw new Exception(String.valueOf(nom_continue_qui_caracterise) + " inconnue");
            }
            mod_a_caracteriser.setDescCont(cont_qui_caracterise, vtest);
        }
        catch (Exception e) {
            FenetreErreur.display(e);
        }
    }

    public void add_description_mod_par_nom(String nom_modalite_a_caracteriser, String nom_nominale_qui_caracterise, double vtest) {
        try {
            Modalite mod_a_caracteriser = this.m_don.getModalite(nom_modalite_a_caracteriser);
            if (mod_a_caracteriser == null) {
                throw new Exception(String.valueOf(nom_modalite_a_caracteriser) + " inconnue");
            }
            Nominale nom_qui_caracterise = this.m_don.getNominale(nom_nominale_qui_caracterise);
            if (nom_qui_caracterise == null) {
                throw new Exception(String.valueOf(nom_nominale_qui_caracterise) + " inconnue");
            }
            mod_a_caracteriser.setDescNom(nom_qui_caracterise, vtest);
        }
        catch (Exception e) {
            FenetreErreur.display(e);
        }
    }

    public void add_description_cont_par_mod(String nom_continue_a_caracteriser, String nom_modalite_qui_caracterise, double vtest) {
        try {
            ContinueAnalysee cont_a_caracteriser = this.m_don.getContinue(nom_continue_a_caracteriser);
            Modalite mod_qui_caracterise = this.m_don.getModalite(nom_modalite_qui_caracterise);
            if (cont_a_caracteriser == null) {
                throw new Exception(String.valueOf(nom_continue_a_caracteriser) + " inconnue");
            }
            if (mod_qui_caracterise == null) {
                throw new Exception(String.valueOf(nom_modalite_qui_caracterise) + " inconnue");
            }
            cont_a_caracteriser.setDescMod(mod_qui_caracterise, vtest);
        }
        catch (Exception e) {
            FenetreErreur.display(e);
        }
    }

    public void add_description_cont_par_cont(String nom_continue_a_caracteriser, String nom_continue_qui_caracterise, double vtest) {
        try {
            ContinueAnalysee cont_a_caracteriser = this.m_don.getContinue(nom_continue_a_caracteriser);
            ContinueAnalysee cont_qui_caracterise = this.m_don.getContinue(nom_continue_qui_caracterise);
            if (cont_a_caracteriser == null) {
                throw new Exception(String.valueOf(nom_continue_a_caracteriser) + " inconnue");
            }
            if (cont_qui_caracterise == null) {
                throw new Exception(String.valueOf(nom_continue_qui_caracterise) + " inconnue");
            }
            cont_a_caracteriser.setDescCont(cont_qui_caracterise, vtest);
        }
        catch (Exception e) {
            FenetreErreur.display(e);
        }
    }

    public void add_description_cont_par_nom(String nom_continue_a_caracteriser, String nom_nominale_qui_caracterise, double vtest) {
        try {
            ContinueAnalysee cont_a_caracteriser = this.m_don.getContinue(nom_continue_a_caracteriser);
            Nominale nom_qui_caracterise = this.m_don.getNominale(nom_nominale_qui_caracterise);
            if (cont_a_caracteriser == null) {
                throw new Exception(String.valueOf(nom_continue_a_caracteriser) + " inconnue");
            }
            cont_a_caracteriser.setDescNom(nom_qui_caracterise, vtest);
            if (nom_qui_caracterise == null) {
                throw new Exception(String.valueOf(nom_nominale_qui_caracterise) + " inconnue");
            }
        }
        catch (Exception e) {
            FenetreErreur.display(e);
        }
    }

    public void add_description_nom_par_mod(String nom_nominale_a_caracteriser, String nom_modalite_qui_caracterise, double vtest) {
        try {
            Nominale nom_a_caracteriser = this.m_don.getNominale(nom_nominale_a_caracteriser);
            Modalite mod_qui_caracterise = this.m_don.getModalite(nom_modalite_qui_caracterise);
            if (nom_a_caracteriser == null) {
                throw new Exception(String.valueOf(nom_nominale_a_caracteriser) + " inconnue");
            }
            if (mod_qui_caracterise == null) {
                throw new Exception(String.valueOf(nom_modalite_qui_caracterise) + " inconnue");
            }
            nom_a_caracteriser.setDescMod(mod_qui_caracterise, vtest);
        }
        catch (Exception e) {
            FenetreErreur.display(e);
        }
    }

    public void add_description_nom_par_cont(String nom_nominale_a_caracteriser, String nom_continue_qui_caracterise, double vtest) {
        try {
            Nominale nom_a_caracteriser = this.m_don.getNominale(nom_nominale_a_caracteriser);
            ContinueAnalysee cont_qui_caracterise = this.m_don.getContinue(nom_continue_qui_caracterise);
            if (nom_a_caracteriser == null) {
                throw new Exception(String.valueOf(nom_nominale_a_caracteriser) + " inconnue");
            }
            if (cont_qui_caracterise == null) {
                throw new Exception(String.valueOf(nom_continue_qui_caracterise) + " inconnue");
            }
            nom_a_caracteriser.setDescCont(cont_qui_caracterise, vtest);
        }
        catch (Exception e) {
            FenetreErreur.display(e);
        }
    }

    public void add_description_nom_par_nom(String nom_nominale_a_caracteriser, String nom_nominale_qui_caracterise, double vtest) {
        try {
            Nominale nom_a_caracteriser = this.m_don.getNominale(nom_nominale_a_caracteriser);
            if (nom_a_caracteriser == null) {
                throw new Exception(String.valueOf(nom_nominale_a_caracteriser) + " inconnue");
            }
            Nominale nom_qui_caracterise = this.m_don.getNominale(nom_nominale_qui_caracterise);
            if (nom_qui_caracterise == null) {
                throw new Exception(String.valueOf(nom_nominale_qui_caracterise) + " inconnue");
            }
            nom_a_caracteriser.setDescNom(nom_qui_caracterise, vtest);
        }
        catch (Exception e) {
            FenetreErreur.display(e);
        }
    }

    public static void main(String[] args) {
        parse p = new parse(null, null);
        Registre reg = Fichier.chargerDonnees("./test/res.ca.ser");
        p.m_don = reg.getDonnee();
        IHM.m_dir = "";
        p.generate();
    }

    private double[] getCoord(double[] val) {
        double[] tab = new double[(int)val[2]];
        int decalage = 3;
        int i = 0;
        while (i < tab.length) {
            tab[i] = val[decalage + i];
            ++i;
        }
        return tab;
    }

    private double[] getCos2(double[] val) {
        double[] tab = new double[(int)val[2]];
        int decalage = 3 + (int)val[2] * 2;
        int i = 0;
        while (i < tab.length) {
            tab[i] = val[decalage + i];
            ++i;
        }
        return tab;
    }

    private double[] getContrib(double[] val) {
        double[] tab = new double[(int)val[2]];
        int decalage = 3 + (int)val[2];
        int i = 0;
        while (i < tab.length) {
            tab[i] = val[decalage + i];
            ++i;
        }
        return tab;
    }

    private double[] getZ(double[] val) {
        int nbz = (int)val[3 + (int)val[2] * 3];
        double[] tab = new double[nbz];
        int decalage = 3 + (int)val[2] * 3 + 1;
        int i = 0;
        while (i < tab.length) {
            tab[i] = val[decalage + i];
            ++i;
        }
        return tab;
    }
}

