\name{dynRB_Vn}
\alias{dynRB_Vn}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Relative Dynamic Range Box size per dimension and object
}
\description{
Function returns Dynamic Range Box size of each dimension \eqn{n}. Number of dynamic range boxes (\code{steps}) can be adjusted. Default: \code{steps = 201}
}
\usage{
dynRB_Vn(A = A, steps = 201, correlogram = FALSE, row_col = c(2, 2))
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{A}{
Data frame, where the first column is a character vector and the other columns are numeric vectors.
}
  \item{steps}{
Number of range boxes. Default: \code{steps = 201}
}
\item{correlogram}{
If \code{TRUE}, the correlogram for each species is shown. If \code{FALSE}, no correlogram is shown. Default: \code{correlogram = FALSE}
}
\item{row_col}{
  Number of rows and columns of the figures (correlogram for each species). Default: \code{row_col = c(2, 2)}
}
}
%\details{
%%  ~~ If necessary, more details than the description above ~~
%}
\value{
Data frame containing the summarized niche length for each object and dimension.
%%  ~Describe the value returned
%%  If it is a LIST, use
%%  \item{comp1 }{Description of 'comp1'}
%%  \item{comp2 }{Description of 'comp2'}
%% ...
}
%\references{
%% ~put references to the literature/web site here ~
%}
\author{
Manuela Schreyer \email{manuelalarissa.schreyer@sbg.ac.at},\cr 
Wolfgang Trutschnig \email{Wolfgang.Trutschnig@sbg.ac.at},\cr 
Robert R. Junker \email{Robert.Junker@sbg.ac.at},\cr 
Jonas Kuppler \email{Jonas.Kuppler@uni-duesseldorf.de},\cr 
Arne Bathke \email{Arne.Bathke@sbg.ac.at}
}
%\note{
%%  ~~further notes~~
%}

%% ~Make other sections like Warning with \section{Warning }{....} ~

%\seealso{
%% ~~objects to See Also as \code{\link{help}}, ~~~
%}
\examples{
# example function dynRB_Vn
# for reliable results use steps = 201
data(finch2)
r<-dynRB_Vn(finch2, steps = 101)
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ ~kwd1 }
\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
