% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lags.R
\name{lags}
\alias{lags}
\title{Add Lagged Responses as Predictors to Each Channel of a Dynamite Model}
\usage{
lags(k = 1L, type = c("fixed", "varying"))
}
\arguments{
\item{k}{[\code{integer()}]\cr
Values lagged by \code{k} units of time of each observed response variable
will be added as a predictor for each channel. Should be a positive
(unrestricted) integer.}

\item{type}{[\code{integer(1)}]\cr Either
\code{"fixed"} or \code{"varying"} which indicates whether the coefficients of the
added lag terms should vary in time or not.}
}
\value{
An object of class \code{lags}.
}
\description{
Adds the lagged value of the response of each channel specified via
\code{\link[=dynamiteformula]{dynamiteformula()}} as a predictor to each channel. The added predictors
can be either time-varying or time-invariant.
}
\examples{
obs(y ~ -1 + varying(~x), family = "gaussian") +
  lags(type = "varying") + splines(df = 20)

# A two-channel categorical model with time-invariant predictors
# here, lag terms are specified manually
obs(x ~ z + lag(x) + lag(y), family = "categorical") +
  obs(y ~ z + lag(x) + lag(y), family = "categorical")

# The same categorical model as above, but with the lag terms
# added using 'lags'
obs(x ~ z, family = "categorical") +
  obs(y ~ z, family = "categorical") +
  lags(type = "fixed")

}
