
<!-- README.md is generated from README.Rmd. Please edit that file -->

<a href="https://travis-ci.org/dynverse/dynfeature"><img src="https://travis-ci.org/dynverse/dynfeature.svg" align="left"></a>
<a href="https://codecov.io/gh/dynverse/dynfeature">
<img src="https://codecov.io/gh/dynverse/dynfeature/branch/master/graph/badge.svg" align="left" /></a>
[**ℹ️ Tutorials**](https://dynverse.org)

# Calculating differentially expressed features across a trajectory

Included are methods to

  - Calculate the overall feature importance, using
    `calculate_overall_feature_importance`
  - Calculate the importance of a feature at a bifurcation point, using
    `calculate_milestone_feature_importance`

The plotting of the top features is nicely intergrated into
[dynplot](https://github.com/dynverse/dynplot)

[![dynplot
heatmap](https://raw.githubusercontent.com/dynverse/dynplot/devel/.readme_files/heatmap-1.png)](https://github.com/dynverse/dynplot)

## Latest changes

Check out `news(package = "dynwrap")` or [NEWS.md](NEWS.md) for a
full list of
changes.

<!-- This section gets automatically generated from inst/NEWS.md, and also generates inst/NEWS -->

### Recent changes in dynfeature 1.0.0 (28-03-2019)

  - MINOR CHANGE: Use only one core by default.

  - MINOR CHANGE: Support sparse matrices

### Recent changes in dynfeature 0.2.0 (25-10-2018)

  - SPEED UP: Added `fi_ranger_rf_lite()`, which scales much better
    w.r.t. the number of samples and features, at the cost of increasing
    loss of accuracy at higher dimension sizes.

  - MAJOR CHANGES: Large cleanup of the code. Most notably,
    
      - The format of feature importance method specification and its
        parameters, with format `fi_method = fi_example_method(param1
        = 10, param2 = 4)`. Before, it had to be specified as `method =
        "example_method", method_params = list(param1 = 10, param2
        = 4)`.

  - MINOR CHANGE: Whenever possible, output columns are now factors
    instead of characters.

  - MINOR CHANGE: Add NEWS, and add news section to README.

  - DOCUMENTATION: Turned on markdown for Roxygen.

  - DOCUMENTATION: Improved documentation on expression\_source.

  - TESTING: Improved testing with a larger dataset, and will check
    whether the overall feature importance produces decent results.

  - MINOR CHANGE: Feature importance functions will always return
    factors instead of
characters.

## Dynverse dependencies

<!-- Generated by "update_dependency_graphs.R" in the main dynverse repo -->

![](man/figures/dependencies.png)
