% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_gold_mappings}
\alias{plot_gold_mappings}
\title{Visualise the mapping of the simulations to the gold standard}
\usage{
plot_gold_mappings(
  model,
  selected_simulations = NULL,
  do_facet = TRUE,
  mapping = aes(comp_1, comp_2)
)
}
\arguments{
\item{model}{A dyngen intermediary model for which the simulations have been run with \code{\link[=generate_cells]{generate_cells()}}.}

\item{selected_simulations}{Which simulation indices to visualise.}

\item{do_facet}{Whether or not to facet according to simulation index.}

\item{mapping}{Which components to plot.}
}
\value{
A ggplot2 object.
}
\description{
Visualise the mapping of the simulations to the gold standard
}
\examples{
data("example_model")
plot_gold_mappings(example_model)
}
