% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distribution_super.R
\name{distribution}
\alias{distribution}
\alias{distribution_function}
\alias{quantile_function}
\alias{as.list.distribution}
\alias{as_distribution}
\alias{is_distribution}
\title{Defining, serialising and printing distributions}
\usage{
distribution(lower, upper, ...)

distribution_function(dist)

quantile_function(dist)

\method{as.list}{distribution}(x, ...)

as_distribution(li)

is_distribution(x)
}
\arguments{
\item{lower}{Lower limit of the distribution.}

\item{upper}{Upper limit of the distribution.}

\item{...}{Fields to be saved in the distribution.}

\item{dist}{A distribution object.}

\item{x}{An object which might be a distribution.}

\item{li}{A list to be converted into a distribution.}
}
\description{
Distributions are used to define the domain of an
\code{\link[=integer_parameter]{integer_parameter()}} or a \code{\link[=numeric_parameter]{numeric_parameter()}}.
}
\details{
See the sections below for more information each of the functions.
}
\section{List of all currently implemented distributions}{

\itemize{
\item \code{\link[=expuniform_distribution]{expuniform_distribution()}}
\item \code{\link[=normal_distribution]{normal_distribution()}}
\item \code{\link[=uniform_distribution]{uniform_distribution()}}
}
}

\section{Serialisation}{

\itemize{
\item \code{as.list(dist)}: Converting a distribution to a list.
\item \code{as_distribution(li)}: Converting a list back to a distribution.
\item \code{is_distribution(x)}: Checking whether something is a distribution.
}
}

\section{Defining a distribution}{

In order to create a new distribution named \code{xxx}, you need to create three functions.
\itemize{
\item A \code{xxx()} function that calls \code{distribution(...) \%>\% add_class("xxx")} at the end.
\item \code{quantile_function.xxx()}: The quantile function for converting between a uniform distribution and the \code{xxx} distribution.
\item \code{distribution_function.xxx()}: The distribution function for converting between a uniform distribution and the \code{xxx} distribution.
}

Check the implementations of \code{\link[=normal_distribution]{normal_distribution()}}, \code{quantile_function.normal_distribution()}
and \code{distribution_function.normal_distribution()} for an example
on how to do define these functions. Alternatively, check the examples below.
}

\examples{
di <- uniform_distribution(lower = 1, upper = 10)
print(di)

li <- as.list(di)
di2 <- as_distribution(li)
print(di2)

# Defining a custom distribution, using the pbeta and qbeta functions
beta_distribution <- function(
  shape1,
  shape2,
  ncp,
  lower = -Inf,
  upper = Inf
) {
  di <- distribution(lower = lower, upper = upper, shape1, shape2, ncp)
  add_class(di, beta_distribution)
}

distribution_function.beta_distribution <- function(dist) {
  function(q) {
    stats::pbeta(q, shape1 = dist$shape1, shape2 = dist$shape2, ncp = dist$ncp)
  }
}

quantile_function.beta_distribution <- function(dist) {
  function(p) {
    stats::qbeta(p, shape1 = dist$shape1, shape2 = dist$shape2, ncp = dist$ncp)
  }
}
}
\seealso{
\link{dynparam} for an overview of all dynparam functionality.
}
