% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_dendro.R
\name{plot_dendro}
\alias{plot_dendro}
\title{Plot a trajectory as a dendrogram}
\usage{
plot_dendro(
  trajectory,
  color_cells = c("auto", "none", "grouping", "feature", "milestone", "pseudotime"),
  grouping = NULL,
  groups = NULL,
  feature_oi = NULL,
  expression_source = "expression",
  pseudotime = NULL,
  color_milestones = c("auto", "given", "cubeHelix", "Set3", "rainbow"),
  milestones = NULL,
  milestone_percentages = NULL,
  alpha_cells = 1,
  size_cells = 2.5,
  border_radius_percentage = 0.1,
  diag_offset = 0.05,
  y_offset = 0.2,
  arrow = grid::arrow(type = "closed")
)
}
\arguments{
\item{trajectory}{A dynwrap trajectory.}

\item{color_cells}{How to color the cells.
\itemize{
\item \code{"auto"}: Try to figure out how to color cells depending on whether
one of the \code{grouping}, \code{feature_io}, \code{milestones} or \code{pseudotime} parameters are defined.
\item \code{"none"}: Cells are not coloured.
\item \code{"grouping"}: Cells are coloured according to a grouping (e.g. clustering).
Either the \code{grouping} parameter or \code{trajectory$grouping} must be a named character vector.
\item \code{"feature"}: Cells are coloured according to the values of a given feature (e.g. gene expression).
Either the \code{expression_source} parameter or \code{get_expression(trajectory)} must be a matrix.
Parameter \code{feature_oi} must also be defined.
\item \code{"milestone"} (recommended): Cells are coloured according their position in the trajectory. The positioning of the
cells are determined by parameter \code{milestone_percentages} or else by \code{trajectory$milestone_percentages}. The colours
of the milestones can be determined automatically or can be specified by passing a tibble containing character columns
\code{milestone_id} and \code{color} (See \code{add_milestone_coloring()} for help in constructing this object).
\item \code{"pseudotime"}: Cells are coloured according to the pseudotime value from the root.
}}

\item{grouping}{A grouping of the cells (e.g. clustering) as a named character vector.}

\item{groups}{A tibble containing character columns \code{group_id} and \code{color}. If \code{NULL}, this object is inferred from the \code{grouping} itself.}

\item{feature_oi}{The name of a feature to use for colouring the cells.}

\item{expression_source}{Source of the feature expression, defaults to \code{get_expression(trajectory)}.}

\item{pseudotime}{The pseudotime from the root of the trajectory to the cells as a named numeric vector.}

\item{color_milestones}{Which palette to use for colouring the milestones
\itemize{
\item \code{auto}: Determine colours automatically. If \code{color} is already specified in
milestones tibble, this will be used. Otherwise, the colour scheme is determined by
\code{milestone_palette_list$auto}.
\item \code{given}: The \code{milestones} object already contains a column \code{color}.
\item \code{cubeHelix}: Use the \code{rje::cubeHelix()} palette.
\item \code{Set3}: Use the \code{RColorBrewer::brewer.pal(name = "Set3")} palette.
\item \code{rainbow}: Use the \code{grDevices::rainbow()} palette.
}}

\item{milestones}{Tibble containing the column \code{milestone_id} (character).
If \code{color_milestones} is set to \code{"given"}, this tibble should also contain a column
\code{color} (character), containing colour hex codes (e.g. \code{"#123456"}).}

\item{milestone_percentages}{The milestone percentages.}

\item{alpha_cells}{The alpha of the cells}

\item{size_cells}{The size of the cells}

\item{border_radius_percentage}{The fraction of the radius that is used for the border}

\item{diag_offset}{The x-offset (percentage of the edge lenghts) between milestones}

\item{y_offset}{The size of the quasirandom cell spreading in the y-axis}

\item{arrow}{The type and size of arrow in case of directed trajectories. Set to NULL to remove arrow altogether.}
}
\value{
A dendrogram ggplot of the trajectory.
}
\description{
Plot a trajectory as a dendrogram
}
\examples{
data(example_tree)
plot_dendro(example_tree)
plot_dendro(example_tree, color_cells = "pseudotime")
plot_dendro(
  example_tree,
  color_cells = "grouping",
  grouping = dynwrap::group_onto_nearest_milestones(example_tree)
)
}
\keyword{plot_trajectory}
