% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_distance.R
\name{calculate_distance}
\alias{calculate_distance}
\alias{list_distance_methods}
\alias{calculate_similarity}
\alias{list_similarity_methods}
\title{Calculate (column-wise) distances/similarity between two matrices}
\usage{
calculate_distance(
  x,
  y = NULL,
  method = c("pearson", "spearman", "cosine", "euclidean", "chisquared", "hamming",
    "kullback", "manhattan", "maximum", "canberra", "minkowski"),
  margin = 1,
  diag = FALSE,
  drop0 = FALSE,
  use_nan = FALSE
)

list_distance_methods()

calculate_similarity(
  x,
  y = NULL,
  margin = 1,
  method = c("spearman", "pearson", "cosine"),
  diag = FALSE,
  drop0 = FALSE,
  use_nan = FALSE
)

list_similarity_methods()
}
\arguments{
\item{x}{A numeric matrix, dense or sparse.}

\item{y}{(Optional) a numeric matrix, dense or sparse, with \code{nrow(x) == nrow(y)}.}

\item{method}{Which distance method to use. Options are: \code{"cosine"}, \code{"pearson"}, \code{"spearman"}, \code{"euclidean"}, and \code{"manhattan"}.}

\item{margin}{integer indicating margin of similarity/distance computation. 1
indicates rows or 2 indicates columns.}

\item{diag}{if \code{TRUE}, only compute diagonal elements of the
similarity/distance matrix; useful when comparing corresponding rows or
columns of `x` and `y`.}

\item{drop0}{if \code{TRUE}, zero values are removed regardless of
\code{min_simil} or \code{rank}.}

\item{use_nan}{if \code{TRUE}, return `NaN` if the standard deviation of a
vector is zero when `method` is "correlation"; if all the values are zero
in a vector when `method` is "cosine", "kullback", "jeffreys" or "chisquared".
Note that use of `NaN` makes the similarity/distance matrix denser and
therefore larger.}
}
\description{
These matrices can be dense or sparse.
}
\examples{
## Generate two matrices with 50 and 100 samples
library(Matrix)
x <- Matrix::rsparsematrix(50, 1000, .01)
y <- Matrix::rsparsematrix(100, 1000, .01)

dist_euclidean <- calculate_distance(x, y, method = "euclidean")
dist_manhattan <- calculate_distance(x, y, method = "manhattan")
dist_spearman <- calculate_distance(x, y, method = "spearman")
dist_pearson <- calculate_distance(x, y, method = "pearson")
dist_angular <- calculate_distance(x, y, method = "cosine")
}
