% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fun_helpers.R
\name{helpersFun}
\alias{helpersFun}
\alias{starmap}
\alias{starred}
\alias{starfilter}
\alias{partition}
\alias{dropwhile}
\alias{takewhile}
\title{Higher Order Helpers for Vector Comprehension}
\usage{
starmap(x, f, axis = 0, ..., longest = TRUE, fill = NULL)

starred(x, f, axis = 0, ..., longest = TRUE, fill = NULL)

starfilter(x, f, axis = 0, ..., longest = TRUE, fill = NULL)

partition(x, f, ...)

dropwhile(x, f, ...)

takewhile(x, f, ...)
}
\arguments{
\item{x}{vector}

\item{f}{function to be applied to \code{x}}

\item{axis}{which axis to perform different operations? \code{axis=0}, the default, performs operations on each element in the list (columns), while \code{axis=1} performs operations on each object within the elements of a list (rows).}

\item{...}{additional arguments passed to lower functions. See \code{\link{funprog}}}

\item{longest}{logical; should the longest item be used to determine the new length or shortest? Defaults to \code{TRUE}.}

\item{fill}{object with which to fill the vector when operating on elements with varying lengths or shifts.}
}
\value{
list or other vector
}
\description{
These functions use a vector and a function to create an iterable object that
can be used for vector comprehension.
}
\details{
The \code{star} functions are similar to their \code{\link{funprog}} counterparts,
except that they are applied one level deeper in the list.
}
\section{Functions}{
\itemize{
\item \code{starmap}: Use \code{map} \code{f} on each element of \code{x}.

\item \code{starred}: Use \code{reduce} \code{f} on each element of \code{x}.

\item \code{starfilter}: Use \code{filter} \code{f} on each element of \code{x}.

\item \code{partition}: Map predicate function \code{f} to each object in \code{x} and split based on which items evaluate to \code{TRUE} (index 1) vs. \code{FALSE} (index 2).

\item \code{dropwhile}: Drop objects from \code{x} until predicate function \code{f} evaluates to \code{FALSE}.

\item \code{takewhile}: Keep objects from \code{x} until predicate function \code{f} evaluates to \code{FALSE}.
}}

\examples{
x <- list(1:3, 4:6, 7:9)

## filter away values less than 6
starfilter(x, ~.i > 5)
starfilter(x, ~.i > 5, axis=1) # Transposed

starred(x, `/`, init=1) # sequentially divide each item, starting at 1

partition(x, ~.i > 5)
}
