man.evenn <-
function()
{
	write("        ,.-.,                                                                         ", file="")
	write("      .`     `.                                                                       ", file="")
	write("     /.-., ,.-.`            *       *                                 ****     ****   ", file="")
	write("   .`    .`.    `.     ***   *     *   ***    ****   ****    *     * *    *   *    *  ", file="")
	write("  / `.  /   `.  / `  *     *  *   *  *     * *    * *    *    *   *      *        *   ", file="")
	write(" |    ',_____,'    | ******   *   *  ******  *    * *    *     * *      *        *    ", file="")
	write(" `.     `   /     /  *         * *   *       *    * *    *     * *    *        *      ", file="")
	write("   ',    '_'    ,'    *****     *     *****  *    * *    *      *    ****** * ******* ", file="")
	write("     `'-'` `'-'`                                                                      ", file="")
	write("\n#####################", file="")
	write("# eVenn Quick Start #", file="")
	write("#####################", file="")
	write("- Prototype:\n\tevenn(annot=FALSE, matLists=\"\", pathRes=\"\", pathLists=\"\", ud=FALSE, noms=\"\", display=FALSE, VennBar=FALSE, Profils=FALSE)", file="")
	write("- Sources: Text tabulated files placed in a folder or matrix or list of matrix (see example data).", file="")
	write("- Venn diagram with up/down details and annotations:\n\tevenn(annot=TRUE, ud=TRUE)", file="")
	write("- Venn diagram with custom short names of lists:\n\tevenn(noms=c(\"A\", \"B\", \"C\", \"D\"))", file="")
	write("- Automate several eVenns:\n\tautoevenn()\n", file="")
	
	write("####################", file="")
	write("# eVenn Quick Help #", file="")
	write("####################", file="")
	write("- annot [TRUE/FALSE]:\tIf the compared lists are files with more than just a column of identifiers (data, annotations or whatever).", file="")
	write("\t\t\tThe identifiers data (Gene name and extended name) must be the 2nd and 3rd columns.", file="")
	write("- matLists [see example data]:\tMatrix, list of matrix or list of lists to be compared..", file="")
	write("- path_res [path]:\tPath used to save the results. The working directory is used by default [getwd()].", file="")
	write("\t\t\tColumns are compared lists, rows are identifiers.", file="")
	write("- ud [TRUE/FALSE]:\tShows the modulations.", file="")
	write("\t\t\tThe source files must comport a \"ratios\" column.", file="")
	write("- Profils [TRUE/FALSE]:\tThis option is valid only if the modulations (UD) are available (ie ratio column or each list) and a DataMoy.txt file containing the means of each group for all the items. The items will be separated by modulations profiles.\n", file="")
	
	write("########################", file="")
	write("# eVenn Quick Examples #", file="")
	write("########################", file="")
	write("library(eVenn)", file="")
	write("YNdisplay = TRUE	# Allows commentaries and display of the main steps of the process\n", file="")

	write("#	Matrix of binary data", file="")
	write("data(Data_Binary_Matrix)", file="")
	write("evenn(matLists=Data_Binary_Matrix, display=YNdisplay, CompName=\"Binary_Matrix\")\n", file="")

	write("#	Matrix of folds", file="")
	write("data(Data_Matrix_Of_Folds)", file="")
	write("evenn(matLists=Data_Matrix_Of_Folds, display=YNdisplay, CompName=\"Matrix_Of_Folds\")\n", file="")

	write("#	Matrix of ratios", file="")
	write("data(Data_Matrix_Of_Ratios)", file="")
	write("evenn(matLists=Data_Matrix_Of_Ratios, display=YNdisplay, CompName=\"Matrix_Of_Ratios\")\n", file="")

	write("#	List of 2, 3 or 4 matrix w/wo modulations and w/wo profils data", file="")
	write("data(Data_Lists)", file="")
	write("evenn(matLists=Data_Lists[c(\"List_1\", \"List_2\")], annot=TRUE, display=YNdisplay, CompName=\"Lists_2\")", file="")
	write("evenn(matLists=Data_Lists[c(\"List_1\", \"List_2\")], ud=TRUE, annot=TRUE, display=YNdisplay, CompName=\"Lists_2_UD\")", file="")
	write("evenn(matLists=Data_Lists[c(\"List_1\", \"List_2\", \"DataMoy\")], ud=TRUE, annot=TRUE, Profils=TRUE, display=YNdisplay, CompName=\"Lists_2_UD_Profils\")\n", file="")
	write("...)", file="")
	write("evenn(matLists=Data_Lists[c(\"List_1\", \"List_2\", \"List_3\", \"List_4\")], annot=TRUE, display=YNdisplay, CompName=\"Lists_4\")", file="")
	write("evenn(matLists=Data_Lists[c(\"List_1\", \"List_2\", \"List_3\", \"List_4\")], ud=TRUE, annot=TRUE, display=YNdisplay, CompName=\"Lists_4_UD\")", file="")
	write("evenn(matLists=Data_Lists[c(\"List_1\", \"List_2\", \"List_3\", \"List_4\", \"DataMoy\")], ud=TRUE, annot=TRUE, Profils=TRUE, display=YNdisplay, CompName=\"Lists_4_UD_Profils\")", file="")
}
