% Generated by roxygen2 (4.0.1): do not edit by hand
\name{getEasingProvidingLiquidity}
\alias{getEasingProvidingLiquidity}
\title{Get credit easing credit providing liquidity data}
\usage{
getEasingProvidingLiquidity(startDate = "012007", endDate = "122100")
}
\arguments{
\item{startDate}{query start date string in MMYYYY format, default 012007}

\item{endDate}{query end date string in MMYYYY format, default 122100}
}
\value{
A list of class \code{easing}
}
\description{
Downloads FRB credit easing policy tools providing liquidity to key credit markets data.
}
\details{
Downloads the Cleveland FRB data product for credit easing policy tools providing liquidity weekly time series, including columns for
\itemize{
\item Maiden Lane
\item asset-backed commercial paper
\item net portfolio holdings commercial paper
\item term asset-backed securities
}
}
\examples{
\dontrun{
pl <- getEasingProvidingLiquidity()
head(pl$df)
}
}
\seealso{
getEasingData getEasingSummary getEasingDetails getEasingLending getEasingCreditDepository getEasingCredtExtensions getEasingMaidenLane getEasingTraditionalHoldings  getEasingAgencyDebt getEasingLongTermPurchases
}

